(ns twitter-stream
  (:require [http.async.client :as c]
            [org.danlarkin.json :as j]))

(def u "ahcclj")
(def p "ahcclj11")

(defn -main []
  (let [resp (c/stream-seq :get "http://stream.twitter.com/1/statuses/sample.json"
                           :auth {:user "ahcclj" :password "ahcclj11"}
                           :timeout -1)]
    (doseq [twit-str (c/string resp)]
      (try
        (let [twit (j/decode-from-str twit-str)
              u (get-in twit [:user :screen_name])
              t (:text twit)]
          (if (or (nil? u) (nil? t))
            (println "Twit not decoded properly: " twit)
            (println u "=>" t)))
        (catch Exception e
          (println "Failed to parse: " twit-str (.getMessage e))))))
  
  (c/close))
