(ns {{ns-name}}.constants
  (:require [clojure.java.io :as io])
  (:import [java.io File]
           [java.util Properties]))

(def props-path "/etc/{{ns-name}}.properties")

(defn load-props []
  (with-open [reader (io/reader props-path)]
    (let [props (Properties.)]
      (.load props reader)
      (into {} (for [[k v] props] [(keyword k) (read-string v)])))))

(def props-map (load-props))

(defn props
  "Returns the property value for the specified key from the supplied
  properties map. If the key doesn't exist, throws an exception."
  [prop-key]
  (if-let [prop-val (props-map prop-key)]
    prop-val
    (throw (Exception. (str "Property " prop-key " is not present in " props-path)))))

;; Application config
(def LOG_LEVEL (keyword (props :log_level)))
(def LOG_PATH (props :log_path))

(def LISTEN_PORT (props :listen_port))

(def FROM_EMAIL (props :from_email))
(def FROM_DISPLAY (props :from_display))

(def AURORA_EMAILS_EXCHANGE "aurora.emails")


;; Hubble
;;--------------------------------------
(def BUBBLE_ID (props :bubble_id))

;--------------------------------------
;	API access
(def API_SERVER (props :api_server))
(def API_KEY (props :api_key))

;--------------------------------------
;	RabbitMQ
(def RABBIT_HOST (props :rabbit_host))
(def RABBIT_PORT (props :rabbit_port))
(def RABBIT_VHOST (props :rabbit_vhost))
(def RABBIT_USER (props :rabbit_user))
(def RABBIT_PASS (props :rabbit_pass))
(def RABBIT_CONN_CONFIG {:username RABBIT_USER
                         :password RABBIT_PASS
                         :host RABBIT_HOST
                         :virtual-host RABBIT_VHOST
                         :port RABBIT_PORT
                         :requested-heartbeat 30
                         :automatically-recover true})

;;--------------------------------------
;; Read only Database
(def AURORA_RO_DB_HOST (props :aurora_ro_db_host))
(def AURORA_RO_DB_PORT (props :aurora_ro_db_port))
(def AURORA_RO_DB_NAME (props :aurora_ro_db_name))
(def AURORA_RO_DB_USER (props :aurora_ro_db_user))
(def AURORA_RO_DB_PASSWORD (props :aurora_ro_db_password))

;; Master db
(def AURORA_DB_HOST (props :aurora_db_host))
(def AURORA_DB_PORT (props :aurora_db_port))
(def AURORA_DB_NAME (props :aurora_db_name))
(def AURORA_DB_USER (props :aurora_db_user))
(def AURORA_DB_PASSWORD (props :aurora_db_password))
