(ns hub.mailer.conf
  (:require [environ.core :as e]))

(def ^:dynamic *env* {})

(defn env
  ([] (merge e/env *env*))
  ([k] ((env) k))
  ([k default] (get (env) k default)))

(defn site
  []
  (env :site :rh))

(defn site-name
  []
  (if (= (site) :pg)
    "PaddleGuru"
    "RaceHub"))

(defn current-server
  []
  (let [prefix (case (env :mode :prod)
                 :dev "local."
                 :staging "staging."
                 :prod "")
        domain (if (= (site) :pg)
                 "paddleguru"
                 "racehubhq")]
    (format "https://%s%s.com" prefix domain)))
