(ns hub.photo.service
  "Photo Service implementation details."
  (:require [com.stuartsierra.component :as c]
            [hub.photo.schema :as ps]
            [hub.util.rethink :as ur]
            [rethinkdb.query :as r]
            [schema.core :as s])
  (:import [com.stuartsierra.component Lifecycle]))

(def photo-table "photo")
(def privacy-table "photo_privacy")
(def bib-mapping "bib_mapping")

(defmacro run-photo
  "Run a command on the photo table."
  [& forms]
  `(ur/run
     (-> (r/db (ur/db-name))
         (r/table photo-table)
         ~@forms)))

(defmacro run
  "Run a command on the configured database."
  [& forms]
  `(ur/run
     (-> (r/db (ur/db-name))
         ~@forms)))

(s/defn get-privacy-info :- (s/maybe ps/UserTagDoc)
  "If the user has privacy settings registered, returns those
  settings."
  [user-id :- s/Str]
  (first
   (run
     (r/table privacy-table)
     (r/get-all [user-id] {:index "by-user-id"}))))
