(def ROOT-DIR (subs *file* 0 (- (count *file*) (count "project.clj"))))
(def VERSION (-> ROOT-DIR (str "/../VERSION") slurp))

(defproject hub.service/photo VERSION
  :description "Photo service."
  :plugins [[lein-modules "0.3.11"]]
  :profiles {:dev {:injections
                   [(require 'schema.core)
                    (schema.core/set-fn-validation! true)]}}
  :dependencies [[com.stuartsierra/component "_"]
                 [environ "1.0.0"]
                 [hub.service/queue :version]
                 [hub.util/rethink :version]
                 [racehub/schema "_"]
                 [rethinkdb "_"]])
