(ns hub.user.schema
  (:require [schema.core :as s]))

;; # User
;;
;; The user model's responsible for
;;
;; - Authentication
;; - identity across tickets, etc
;; - holds info about the user's profile

(s/defschema EMailMap
  {:address s/Str
   :verified? s/Bool
   (s/optional-key :activation-code) s/Str})

(def UserName s/Str)

(s/defschema User
  {:id s/Str
   :username UserName
   :email EMailMap
   ;; profile, etc
   })

;; This one's interesting, because a race might require that they have
;; a bunch of info about that user.
;;
;; This might also be a GUEST user that signed up for a race without
;; an account.
(s/defschema PendingUser
  "User record for a user without an account."
  {:id s/Str
   :name ""
   :meta {s/Any s/Any}})

(s/defschema Merge
  "Created in case of a merge. The original user gets destroyed."
  {:id s/Str
   :from s/Str
   :to s/Str})
