(ns hub.user.api.schema
  "User Service API schema."
  (:require [hub.user.schema :as us]
            [schema.core :as s]))

(s/defschema Err
  {:error
   {:type s/Str
    (s/optional-key :param) s/Str
    (s/optional-key :message) s/Str}})

(def ID us/UserID)

(def Profile us/Profile)
(def FullName us/FullName)
(def UserName us/UserName)

(def RethinkFields
  "Explicitly shadowing here, in case we want amend these fields."
  us/RethinkFields)

(s/defschema FullUser
  "Something like this. Doesn't quite have to match the DB
  representation."
  (merge RethinkFields
         {:username s/Str
          :email us/EMailMap
          :password-set? (s/named s/Bool "Is the user's PW set?")
          :roles #{(s/enum "user" "superadmin")}
          :profile us/Profile
          :type (s/eq "full-user")
          :oauth (s/named {s/Keyword s/Str}
                          "Map of oauth provider to the name given by that
                   provider.")}))

(def PendingUserInput us/PendingUserInput)

(s/defschema User
  (s/either FullUser
            us/PendingUser))

(s/defschema LookupType
  "Ways to search for some user."
  (s/enum :username :id :email :facebook-email :facebook-id))
