(ns hub.user.transforms
  (require [hub.user.api.schema :as as]
           [hub.user.schema :as us]
           [schema.core :as s]))

(s/defn user-model->user-api :- as/User
  "Converts from model representation of a user doc to the API
  representation. Handles full and pending users."
  [{:keys [password oauth] :as user} :- us/User]
  (if (= (:type user) "pending")
    user
    (let [base (select-keys user [:username :email :type :profile])
          oauth->name (reduce (fn [acc [provider {:keys [token metadata]}]]
                                (assoc acc provider (:name metadata)))
                              {}
                              oauth)]
      (merge base
             {:password-set? (boolean (not-empty password))
              :roles "user"
              :oauth oauth->name}))))
