(ns hub.user.api.schema
  "User Service API schema."
  (:require [hub.user.schema :as us]
            [schema.core :as s]))

(def ID us/UserID)

(def Profile us/Profile)
(def PendingProfile us/PendingProfile)
(def FullName us/FullName)
(def UserName us/UserName)

(def RethinkFields
  "Explicitly shadowing here, in case we want amend these fields."
  us/RethinkFields)

(def SignupFields
  us/SignupFields)

(s/defschema Role
  (s/enum "user" "superadmin"))

(s/defschema FullUserInput
  {:username s/Str
   :email us/EMailMap
   :profile Profile
   :roles (s/both #{Role} (s/pred not-empty))
   :password-set? s/Bool
   :type (s/eq "full-user")
   :oauth (s/named {s/Keyword {:name s/Str
                               :id s/Str
                               :token s/Str}}
                   "Map of oauth provider to info.")})

(s/defschema FullUser
  "Something like this. Doesn't quite have to match the DB
  representation."
  (merge FullUserInput
         RethinkFields))

(def PendingUserInput us/PendingUserInput)

(def PendingUser
  (assoc us/PendingUser :type (s/eq "pending-user")))

(s/defschema User
  (s/either FullUser
            PendingUser))

(s/defschema UserUpdate
  "Schema for fields that can be update!-ed"
  (merge (dissoc Profile (s/optional-key :name))
         {(s/optional-key :name) (s/named s/Str "For pending users only.")
          (s/optional-key :first-name) s/Str
          (s/optional-key :last-name) s/Str
          (s/optional-key :password) (s/named s/Str "plaintext pw")
          (s/optional-key :email-address) s/Str
          (s/optional-key :username) s/Str}))

(s/defschema LookupType
  "Ways to search for some user."
  ;;TODO: add :facebook-email :facebook-id
  (s/enum :id :email :username :name))
