(ns lein-bouncy.core
  (:require [clojure.string :as str]
            [leiningen.core.classpath :as cp]))

(defn get-bouncy-dependencies [project]
  (filter #(str/starts-with? (str (first %)) "org.bouncycastle")
          (:dependencies project)))

(defn get-bouncy-files [project]
  (let [bc (get-bouncy-dependencies project)]
    (cp/resolve-dependencies
      :dependencies
      {:dependencies bc})))
