(ns lein-bouncy.plugin
  (:require [clojure.string :as str]
            [leiningen.core.project :as p]
            [lein-bouncy.core :as core]))

(defn append-manifest-classpath [project]
  (if (:manifest project)
    (let [bc (core/get-bouncy-files project)
          classpath (str/join \space (map #(.getName %) bc))]
      (update-in project [:manifest "Class-Path"] #(if (str/blank? %)
                                                    classpath
                                                    (if (str/includes? % classpath)
                                                      %
                                                      (str % " " classpath)))))
    project))

(defn append-prep-task [project]
  (update-in project [:prep-tasks] conj "bouncy"))

(defn append-uberjar-exclusions [project]
  (update-in project [:uberjar-exclusions] conj #"org.bouncycastle"))

(defn middleware [project]
  (-> project
      append-prep-task
      append-manifest-classpath
      append-uberjar-exclusions))
