(ns lein-bouncy.plugin
  (:require [clojure.string :as str]
            [leiningen.core.main :as main]
            [leiningen.core.classpath :as cp]
            [leiningen.uberjar :as uberjar]
            [robert.hooke :as hook]
            [lein-bouncy.core :as core]))

(defn append-manifest-classpath [project]
  (if (:manifest project)
    (let [bc (core/get-bouncy-files project)
          classpath (str/join \space (map #(.getName %) bc))]
      (update-in project [:manifest "Class-Path"] #(if (str/blank? %)
                                                    classpath
                                                    (if (str/includes? % classpath)
                                                      %
                                                      (str % " " classpath)))))
    project))

(defn append-prep-task [project]
  (update-in project [:prep-tasks] conj "bouncy"))

(defn hook-write-components [f project jars out]
  (let [files (core/get-bouncy-files project)
        jars (filter (fn [j]
                       (not-any? #(= (.getName j) (.getName %))
                                 files))
                     jars)]
    (doseq [j files]
      (main/debug "Excluded" (.getName j)))

    (f project jars out)))

(defn hooks []
  (hook/add-hook #'uberjar/write-components
                 #'hook-write-components))

(defn middleware [project]
  (-> project
      append-prep-task
      append-manifest-classpath))
