(ns lein-bouncy.plugin
  (:require [clojure.string :as str]
            [leiningen.core.main :as main]
            [leiningen.core.classpath :as cp]
            [leiningen.uberjar :as uberjar]
            [robert.hooke :as hook]
            [lein-bouncy.core :as core]
            [clojure.java.io :as io]))

(defn includes?
  "True if s includes substr."
  {:added "1.8"}
  [^CharSequence s ^CharSequence substr]
  (.contains (.toString s) substr))

(defn append-manifest-classpath [project]
  (if (:manifest project)
    (let [bc (core/get-bouncy-files project)
          classpath (str/join \space (map #(.getName %) bc))]
      (update-in project [:manifest "Class-Path"] #(if (str/blank? %)
                                                    classpath
                                                    (if (includes? % classpath)
                                                      %
                                                      (str % " " classpath)))))
    project))

(defn hook-write-components [f project jars out]
  (let [files (core/get-bouncy-files project)
        target (:target-path project)
        jars (filter (fn [j]
                       (not-any? #(= (.getName j) (.getName %))
                                 files))
                     jars)]
    (doseq [j files]
      (main/info "Copying" (.getName j))
      (io/copy j (java.io.File. (str target "/" (.getName j)))))

    (f project jars out)))

(defn hooks []
  (hook/add-hook #'uberjar/write-components
                 #'hook-write-components))

(defn middleware [project]
  (-> project
      append-manifest-classpath))
