(ns lein-bouncy.core
  (:require [clojure.string :as str]
            [leiningen.core.main :as main]
            [cemerick.pomegranate.aether :as aether]
            [leiningen.core.classpath :as cp]))

(alter-meta! #'leiningen.core.classpath/get-dependencies assoc :private false)

(defn get-dependencies [project]
  ;; 2.7.0 broke this code
  (if (main/version-satisfies? (main/leiningen-version) "2.7.0")
    (cp/get-dependencies :dependencies :managed-dependencies project)
    (cp/get-dependencies :dependencies project)))

(defn get-bouncy-dependencies [project]
  ;; TODO: walk dependencies tree
  (let [res (get-in project [:bouncy :extract-dependencies] [])
        deps (filter (fn [dep]
                       (some #(re-find % (str (first dep))) res))
                     (mapv
                       first
                       (get-dependencies project)))]
    deps))

(defn get-bouncy-files [project]
  (let [bc (get-bouncy-dependencies project)]
    (mapv #(:file (meta %)) bc)))
