(ns holon.component
  (:require [                                 
                    quile.component
             :as component :refer [system-map        SystemMap]]
                                                                        
                                      
                   [schema.core :as s :include-macros true]
                                                  
            [ib5k.component.ctr :as ctr]
            [ib5k.component.using-schema :as us]
            [plumbing.core :refer [map-vals]])
       
                                                  )

(s/defschema ComponentMap
  {s/Keyword {:cmp s/Any
              (s/optional-key :using) us/Dependencies
                                                                    }})

(s/defschema UpdateComponent
  [(s/one (s/make-fn-schema [[s/Any]] [[s/Any]]) "cmp update fn") s/Any])

     
                                              
                                                                                   
                                                                 
                                                                      
                         
                                                      
                          
                                                                  
                                    
                                               

(s/defn extract-key :- {s/Keyword s/Any}
  [component-map :- ComponentMap
   key :- (s/enum :cmp :using                )]
  (->> component-map
       (map-vals key)
       (remove (comp nil? second))
       (into {})))

(s/defn new-system :- us/SystemMap
  [component-map :- ComponentMap]
  (let [system (->> (extract-key component-map :cmp)
                    (apply concat)
                    (apply system-map))]
    (-> system
        (us/system-using-schema (extract-key component-map :using))
                                                                            )))

;; taken from https://github.com/milesian/BigBang/blob/master/src/milesian/bigbang.clj
(s/defn expand :- us/SystemMap
  [system-map :- us/SystemMap
   {:keys [before-start
           after-start]
    :or {before-start []
         after-start []}} :- {(s/optional-key :before-start) [UpdateComponent]
                              (s/optional-key :after-start) [UpdateComponent]}]
  (let [on-start-sequence (apply conj before-start (cons [component/start] after-start))
        start (fn [c & args]
                (apply (->> on-start-sequence
                            (mapv (fn [[f & args]]
                                    #(apply f (conj args %))))
                            reverse
                            (apply comp))
                       (conj args c)))]
    (component/update-system system-map (keys system-map) start)))

     
                             
                          
                                  
                                                                 
                                                                                    
                                                        
                                                                                
                                                           

      
(s/defn start :- us/SystemMap
  [system :- us/SystemMap]
  (expand system {:before-start [[ctr/validate-class]]
                  :after-start [[ctr/validate-class]]}))

;;;;;;;;;;;; This file autogenerated from holon/component.cljx
