/*
 * Decompiled with CFR 0.152.
 */
package ifesdjeen.stateless4j;

import ifesdjeen.stateless4j.StateConfiguration;
import ifesdjeen.stateless4j.StateReference;
import ifesdjeen.stateless4j.StateRepresentation;
import ifesdjeen.stateless4j.delegates.Action1;
import ifesdjeen.stateless4j.delegates.Action2;
import ifesdjeen.stateless4j.delegates.Func;
import ifesdjeen.stateless4j.delegates.Func2;
import ifesdjeen.stateless4j.exceptions.CannotReconfigureParameters;
import ifesdjeen.stateless4j.exceptions.StateMachineConfigurationException;
import ifesdjeen.stateless4j.exceptions.TriggerIgnoredException;
import ifesdjeen.stateless4j.exceptions.UnhandledTriggerActionException;
import ifesdjeen.stateless4j.transitions.Transition;
import ifesdjeen.stateless4j.transitions.TransitioningTriggerBehaviour;
import ifesdjeen.stateless4j.triggers.TriggerBehaviour;
import ifesdjeen.stateless4j.triggers.TriggerWithParameters;
import ifesdjeen.stateless4j.triggers.TriggerWithParameters1;
import ifesdjeen.stateless4j.triggers.TriggerWithParameters2;
import ifesdjeen.stateless4j.triggers.TriggerWithParameters3;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class StateMachine<TState, TTrigger> {
    final Map<TState, StateRepresentation<TState, TTrigger>> _stateConfiguration = new HashMap<TState, StateRepresentation<TState, TTrigger>>();
    final Map<TTrigger, TriggerWithParameters<TState, TTrigger>> _triggerConfiguration = new HashMap<TTrigger, TriggerWithParameters<TState, TTrigger>>();
    final Func<TState> _stateAccessor;
    final Action1<TState> _stateMutator;
    Action2<TState, TTrigger> _unhandledTriggerAction = new Action2<TState, TTrigger>(){

        @Override
        public void doIt(TState state, TTrigger trigger) {
        }
    };

    public StateMachine(TState initialState) {
        final StateReference reference = new StateReference();
        reference.setState(initialState);
        this._stateAccessor = new Func<TState>(){

            @Override
            public TState call() {
                return reference.getState();
            }
        };
        this._stateMutator = new Action1<TState>(){

            @Override
            public void doIt(TState s) {
                reference.setState(s);
            }
        };
    }

    public TState getState() {
        return this._stateAccessor.call();
    }

    private void setState(TState value) {
        this._stateMutator.doIt(value);
    }

    public List<TTrigger> getPermittedTriggers() {
        return this.getCurrentRepresentation().getPermittedTriggers();
    }

    StateRepresentation<TState, TTrigger> getCurrentRepresentation() {
        return this.GetRepresentation(this.getState());
    }

    StateRepresentation<TState, TTrigger> GetRepresentation(TState state) {
        if (!this._stateConfiguration.containsKey(state)) {
            StateRepresentation result = new StateRepresentation(state);
            this._stateConfiguration.put(state, result);
        }
        return this._stateConfiguration.get(state);
    }

    public StateConfiguration<TState, TTrigger> Configure(TState state) {
        return new StateConfiguration<TState, TTrigger>(this.GetRepresentation(state), new Func2<TState, StateRepresentation<TState, TTrigger>>(){

            @Override
            public StateRepresentation<TState, TTrigger> call(TState arg0) {
                return StateMachine.this.GetRepresentation(arg0);
            }
        });
    }

    public void Fire(TTrigger trigger) throws StateMachineConfigurationException {
        this.publicFire(trigger, new Object[0]);
    }

    public <TArg0> void Fire(@Nonnull TriggerWithParameters1<TArg0, TState, TTrigger> trigger, TArg0 arg0) throws StateMachineConfigurationException {
        this.publicFire(trigger.getTrigger(), arg0);
    }

    public <TArg0, TArg1> void Fire(@Nonnull TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> trigger, TArg0 arg0, TArg1 arg1) throws StateMachineConfigurationException {
        this.publicFire(trigger.getTrigger(), arg0, arg1);
    }

    public <TArg0, TArg1, TArg2> void Fire(@Nonnull TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> trigger, TArg0 arg0, TArg1 arg1, TArg2 arg2) throws StateMachineConfigurationException {
        this.publicFire(trigger.getTrigger(), arg0, arg1, arg2);
    }

    void publicFire(TTrigger trigger, Object ... args) throws StateMachineConfigurationException {
        TriggerBehaviour<TState, TTrigger> triggerBehaviour;
        if (this._triggerConfiguration.containsKey(trigger)) {
            TriggerWithParameters<TState, TTrigger> configuration = this._triggerConfiguration.get(trigger);
            configuration.ValidateParameters(args);
        }
        try {
            triggerBehaviour = this.getCurrentRepresentation().TryFindHandler(trigger);
        }
        catch (Exception e) {
            this._unhandledTriggerAction.doIt(this.getCurrentRepresentation().getUnderlyingState(), trigger);
            return;
        }
        TState source = this.getState();
        try {
            TState destination = triggerBehaviour.ResultsInTransitionFrom(source, args);
            Transition<TState, TTrigger> transition = new Transition<TState, TTrigger>(source, destination, trigger);
            this.getCurrentRepresentation().Exit(transition);
            this.setState(transition.getDestination());
            this.getCurrentRepresentation().Enter(transition, args);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void OnUnhandledTrigger(Action2<TState, TTrigger> unhandledTriggerAction) throws UnhandledTriggerActionException {
        if (unhandledTriggerAction == null) {
            throw new UnhandledTriggerActionException();
        }
        this._unhandledTriggerAction = unhandledTriggerAction;
    }

    public Boolean IsInState(TState state) {
        return this.getCurrentRepresentation().IsIncludedIn(state);
    }

    public Boolean CanFire(TTrigger trigger) {
        return this.getCurrentRepresentation().CanHandle(trigger);
    }

    public String toString() {
        List<TTrigger> permittedTriggers = this.getPermittedTriggers();
        ArrayList<String> parameters = new ArrayList<String>();
        for (TTrigger tTrigger : permittedTriggers) {
            parameters.add(tTrigger.toString());
        }
        return String.format("StateMachine {{ State = {0}, PermittedTriggers = {{ {1} }}}}", this.getState(), ((Object)parameters).toString());
    }

    public <TArg0> TriggerWithParameters1<TArg0, TState, TTrigger> SetTriggerParameters(TTrigger trigger, Class<TArg0> classe0) throws CannotReconfigureParameters {
        TriggerWithParameters1 configuration = new TriggerWithParameters1(trigger, classe0);
        this.SaveTriggerConfiguration(configuration);
        return configuration;
    }

    public <TArg0, TArg1> TriggerWithParameters2<TArg0, TArg1, TState, TTrigger> SetTriggerParameters(TTrigger trigger, Class<TArg0> classe0, Class<TArg1> classe1) throws CannotReconfigureParameters {
        TriggerWithParameters2 configuration = new TriggerWithParameters2(trigger, classe0, classe1);
        this.SaveTriggerConfiguration(configuration);
        return configuration;
    }

    public <TArg0, TArg1, TArg2> TriggerWithParameters3<TArg0, TArg1, TArg2, TState, TTrigger> SetTriggerParameters(TTrigger trigger, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) throws CannotReconfigureParameters {
        TriggerWithParameters3 configuration = new TriggerWithParameters3(trigger, classe0, classe1, classe2);
        this.SaveTriggerConfiguration(configuration);
        return configuration;
    }

    void SaveTriggerConfiguration(TriggerWithParameters<TState, TTrigger> trigger) throws CannotReconfigureParameters {
        if (this._triggerConfiguration.containsKey(trigger.getTrigger())) {
            throw new CannotReconfigureParameters();
        }
        this._triggerConfiguration.put(trigger.getTrigger(), trigger);
    }

    public void GenerateDotFileInto(OutputStream dotFile) throws UnsupportedEncodingException, TriggerIgnoredException {
        OutputStreamWriter w = new OutputStreamWriter(dotFile, "UTF-8");
        PrintWriter writer = new PrintWriter(w);
        writer.write("digraph G {\n");
        for (Map.Entry<TState, StateRepresentation<TState, TTrigger>> entry : this._stateConfiguration.entrySet()) {
            Map behaviours = entry.getValue()._triggerBehaviours;
            for (Map.Entry behaviour : behaviours.entrySet()) {
                for (TriggerBehaviour triggerBehaviour : behaviour.getValue()) {
                    if (!(triggerBehaviour instanceof TransitioningTriggerBehaviour)) continue;
                    writer.write(String.format("\t%s -> %s;\n", entry.getKey(), triggerBehaviour.ResultsInTransitionFrom(null, new Object[0])));
                }
            }
        }
        writer.write("}");
        writer.close();
    }
}

