(ns ike.gradleui.reloaded
  (:require [ike.gradleui :refer [gradleui-service]]
            [ike.gradleui.httpkit :refer [http-kit-service]]
            [puppetlabs.trapperkeeper.core :as tk]
            [puppetlabs.trapperkeeper.app :as tka]
            [clojure.tools.namespace.repl :refer (refresh)])
  (:gen-class))

(def system nil)

(defn init
  []
  (alter-var-root #'system
                  (fn [_] (tk/build-app
                           [http-kit-service
                            gradleui-service]
                           {:global {:logging-config "logback.xml"}})))
  (alter-var-root #'system tka/init)
  (tka/check-for-errors! system))

(defn start
  []
  (alter-var-root #'system
                  (fn [s] (if s (tka/start s))))
  (tka/check-for-errors! system))

(defn stop
  []
  (alter-var-root #'system
                  (fn [s] (when s (tka/stop s)))))

(defn go
  []
  (init)
  (start))

(defn context
  []
  @(tka/app-context system))

(defn print-context
  []
  (clojure.pprint/pprint (context)))

(defn reset
  []
  (stop)
  (refresh :after 'ike.gradleui.reloaded/go))
