(ns ike.gradleui.routes
  (use [compojure.core])
  (require [compojure.route :refer [resources]]
           [ring.util.response :refer [redirect]]
           [ring.middleware.params :refer [wrap-params]]
           [ike.gradleui.gradle :as gradle]
           [clojure.string :as string])
  (:gen-class))

(defroutes app-routes
  (context "/app" []
           (GET "/" []
                (redirect "/app/home.html"))
           (GET "/display" [message]
                (str "Message: " message))
           (POST "/build" [command]
                 (gradle/start-build! "/home/andrew/projects/grgit"
                                      (string/split command #"\s+"))
                 (redirect (str "display?message=Started the build.")))
           (resources "")))

(def app
  (-> app-routes
      (wrap-params)))



(defroutes api-routes
  (context "/api" []
           (POST "/build" [project tasks]
                 (gradle/start-build! project
                                      (string/split tasks #"\s+"))
                 (str "Started build for " project " with tasks " tasks))))

(def api
  (-> api-routes
      (wrap-params)))
