(ns ike.highway
  (:require [com.stuartsierra.component :as component]
            [ike.util.aleph :as aleph]
            [ike.highway.bus :as bus]
            [ike.highway.routes :as routes]
            [clojure.tools.reader.edn :as edn])
  (:gen-class))

(defn system
  [aleph-opts]
  (component/system-map
    :ike/bus (bus/new-bus)
    :handler (component/using
               {:handler-fn routes/all}
               [:ike/bus])
    :server (component/using
              (aleph/new-server aleph-opts)
              [:handler])))

(defn -main
  [& args]
  (let [port-arg (some-> args first edn/read-string)
        port (if (number? port-arg) port-arg 9435)]
    (component/start-system (system {:port port}))))
