(ns ike.highway.bus
  (:require [clojure.core.async :as async]
            [clojure.tools.logging :as log]
            [ike.util.component :as component]
            [ike.util.transducers :as xf]))

(declare new-bus)

(defrecord EventBus
  [bus-ch bus-mix bus-mult]
  component/IdempotentLifecycle
  (-started? [this] (:bus-ch this))
  (-start [this] this)
  (-stop [this]
    (let [bus-ch (:bus-ch this)]
      (async/close! bus-ch)
      (new-bus))))

(component/extend-lifecycle EventBus)

(defn new-bus []
  (let [bus-ch (async/chan (async/buffer 1) (xf/peek #(log/trace "Event: " %)))
        bus-mix (async/mix bus-ch)
        bus-mult (async/mult bus-ch)]
    (->EventBus bus-ch bus-mix bus-mult)))
