(ns ike.ramp
  (:require [ike.util.aleph :as aleph]
            [clojure.core.async :as async]))

(defrecord Ramp [in-ch mult out-ch mix])

(defn new-ramp [in-ch out-ch]
  (->Ramp in-ch (async/mult in-ch) out-ch (async/mix out-ch)))

(defn connect
  ([url] (connect url (async/chan) (async/chan)))
  ([url in-ch out-ch]
   (aleph/async->websocket url in-ch out-ch)
   (new-ramp in-ch out-ch)))

(defn connect-in
  ([url] (connect-in url (async/chan)))
  ([url in-ch]
    (connect url in-ch (async/chan (async/sliding-buffer 1)))))

(defn connect-out
  ([url] (connect-out url (async/chan)))
  ([url out-ch]
    (connect url (async/chan) out-ch)))

(defn close [ramp]
  (-> ramp :out-ch async/close!))

(defn onramp [ramp ch]
  (async/admix (:mix ramp) ch))

(defn offramp [ramp f]
  (let [ch (async/chan)]
    (async/tap (:mult ramp) ch)
    (f ch)))
