(ns ike.ramp.maven
  (:require [clojure.core.async :as async]
            [clojure.data.xml :as xml]
            [clojure.java.io :as io]
            [ike.ramp.file :as file]))

(defn- get-element
  [data tag]
  (->> data :content (filter #(= tag (:tag %))) (mapcat :content) first))

(defn- pom->module
  [file]
  (with-open [rdr (io/reader file)]
    (let [data (xml/parse rdr)]
      {:type    "maven"
       :repo    (-> file io/as-url str)
       :group   (get-element data :groupId)
       :name    (get-element data :artifactId)
       :version (get-element data :version)})))

(defn maven->chan
  "Onramp that puts events for modules published within the given Maven
  repository. Argument should be the path to the root dir of the Maven
  repository to watch. If no arguments given, uses the '.m2' directory
  in the current user's home directory."
  ([] (maven->chan (str (System/getProperty "user.home") ".m2")))
  ([path-str]
   (let [event-ch (async/chan 25 (comp (filter #(= :create (:action %)))
                                       (map :file)
                                       (file/filter-ext "pom")
                                       (map pom->module)))]
     (file/watch->chan path-str event-ch))))
