# ike.tk.httpkit

Provides a Trapperkeeper service to start http-kit with a Ring handler.

## Usage

Add this project as a dependency to your project:

[![Clojars Project](http://clojars.org/ike/ike.tk.httpkit/latest-version.svg)](http://clojars.org/ike/ike.tk.httpkit)

Write a `HandlerService` to provide your app's ring handler:

```clojure
(ns ike.example
  (require [ike.tk.ring :refer [HandlerService]]
           [puppetlabs.trapperkeeper.services :refer [defservice]]))

(defservice test-service
  HandlerService
  []
  (get-handler [this]
               (fn [request]
                   {:status 200
                    :headers {"Content-Type" "text/html"}
                    :body "Hello World!"})))
```

In your `bootstrap.cfg` add your `HandlerService` and the `http-kit-service`.

```
ike.example/test-service
ike.tk.httpkit/http-kit-service
```

Optionally, configure `http-kit` in your config (see the `http-kit` [docs](http://http-kit.org/server.html#options)):

```
http-kit {
  port = 8080
}
```

Then, fire up Trapperkeeper and you're all done!

## License

Copyright © 2014 Andrew Oberstar

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
