(ns ike.util.ring)

(defn- wrap-component
  "Ring middleware to add a component to the request map using the given key."
  [handler [key component]]
  (fn [request]
    (handler (assoc request key component))))

(defn make-handler
  "Creates a handler function from the handler map/component.
  The :handler-fn key should be a normal Ring handler. Any additional
  keys will be used in middleware to add them to the request."
  [handler]
  (let [handler-fn (:handler-fn handler)
        components (dissoc handler :handler-fn)]
    (reduce wrap-component handler-fn components)))
