# ike.util

Common utilities for various Clojure libraries.

You can get it from Clojars.

[![Clojars Project](http://clojars.org/ike/ike.util/latest-version.svg)](http://clojars.org/ike/ike.util)

## Overview

- Stuart Sierra's Component
    - `IdempotentLifecycle` protocol to make it easier to implement Lifecycle idempotently.
- Ring
    - `make-handler` function that wraps a handler function with middleware that adds components to the request map
- Aleph
    - `AlephRingServer` component (uses `IdempotentLifecycle` and `make-handler`)
    - `websocket->async` for using core.async as interface to an Aleph websocket on server-side
    - `async->websocket` for using core.async as interface to an Aleph websocket on client-side
- Transducers
    - `peek` for applying a function to each item coming through the transducer, without modifying it
    - `reductions` for accumulating the results of a function and having the accumulated result as of each item be passed
    to the next item in the stack
