(ns ike.util.component
  (:require [com.stuartsierra.component :as component]))

(defprotocol IdempotentLifecycle
  "Protocol to ease implementation of idempotent components
  for Stuart Sierra's Component library. After extending
  this protocol you should call extend-lifecycle with your
  type."
  (-started? [this])
  (-start [this])
  (-stop [this]))

(defn extend-lifecycle
  "Extends Lifecycle for a type satisfying IdempotentLifecycle.
  start will only call -start if -started? returns false. stop
  will only call -stop if -started? returns true."
  [atype]
  (extend atype
    component/Lifecycle
    {:start (fn [this]
              (if (-started? this)
                this
                (-start this)))
     :stop (fn [this]
             (if (-started? this)
               (-stop this)
               this))}))
