(defproject im.chit/lucid.aether "1.3.3"
  :description "tools for code clarity"
  :url "https://www.github.com/zcaudate/lucidity"
  :license {:name "The MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" ":exit"]}
  :dependencies [[org.clojure/clojure "1.8.0"] [org.eclipse.aether/aether-spi "1.1.0"] [org.eclipse.aether/aether-transport-http "1.1.0"] [im.chit/hara.reflect "2.5.1"] [org.eclipse.aether/aether-api "1.1.0"] [org.eclipse.aether/aether-transport-file "1.1.0"] [im.chit/hara.object "2.5.1"] [org.eclipse.aether/aether-connector-basic "1.1.0"] [im.chit/hara.io.classpath "2.5.1"] [org.apache.maven/maven-aether-provider "3.3.9"] [im.chit/hara.io.file "2.5.1"] [org.eclipse.aether/aether-util "1.1.0"]]
  
  :publish {:theme  "stark"
            
            :template {:site   "lucid"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}
            
            :files {"index"
                    {:template "home.html"
                     :input "test/documentation/home_lucidity.clj"
                     :title "lucidity"
                     :subtitle "tools for code clarity"}
                    "lucid-aether"
                    {:input "test/documentation/lucid_aether.clj"
                     :title "aether"
                     :subtitle "wrapper for org.eclipse.aether"}
                    "lucid-core"
                    {:input "test/documentation/lucid_core.clj"
                     :title "core"
                     :subtitle "functions for the code environment"}
                    "lucid-distribute"
                    {:input "test/documentation/lucid_distribute.clj"
                     :title "distribute"
                     :subtitle "code repackaging and distribution"}
                    "lucid-git"
                    {:input "test/documentation/lucid_git.clj"
                     :title "git"
                     :subtitle "wrapper for org.eclipse.jgit"}
                    "lucid-mind"
                    {:input "test/documentation/lucid_mind.clj"
                     :title "mind"
                     :subtitle "contemplative reflection for the jvm"}
                    "lucid-package"
                    {:input "test/documentation/lucid_package.clj"
                     :title "package"
                     :subtitle "project packaging and dependencies"}
                    "lucid-publish"
                    {:input "test/documentation/lucid_publish.clj"
                     :title "publish"
                     :subtitle "generate documentation from code"}
                    "lucid-query"
                    {:input "test/documentation/lucid_query.clj"
                     :title "query"
                     :subtitle "intuitive search for code"}
                    "lucid-system"
                    {:input "test/documentation/lucid_system.clj"
                     :title "system"
                     :subtitle "system information and process monitoring"}
                    "lucid-unit"
                    {:input "test/documentation/lucid_unit.clj"
                     :title "unit"
                     :subtitle "metadata through unit tests"}}}
  
   
  
    
  
  :java-source-paths ["java"]
  
  :jar-exclusions [#"^test\..+\.class"])
