# vinyasa

Give your clojure workflow more flow.

## Installation

Add `vinyasa` to your `profile.clj`:

    {:user {:plugins [...]   
            :dependencies [....
                           [im.chit/vinyasa "0.1.0"]
                           ....]
            ....}
            :injections [...
                         (require '[vinyasa.inject :as inj])            
                         (inj/inject 'clojure.core
                           '[[vinyasa.inject inject]
                             [vinyasa.pull pull]
                             [vinyasa.lein lein]])
                         ...]
          }


## Usage:

If you are in emacs and are in a clojure project, you can run `nrepl-jack-in` and use the added functionality straight away. If you are running lein repl and are in the `user` namespace, reload the `user` namespace before using:

     > (ns user)


### pull

How many times have you forgotten a library dependency for `project.clj` and then had to restart your nrepl? `pull` is a convienient wrapper around the `pomegranate` library:

    > (require 'hiccup.core)
    ;; => java.io.FileNotFoundException: Could not locate hiccup/core__init.class or hiccup/core.clj on classpath:

    > (require 'hiccup.core)
    > (pull 'hiccup)
    ;; => {[org.clojure/clojure "1.2.1"] nil, [hiccup "1.0.4"] #{[org.clojure/clojure "1.2.1"]}}

    > (use 'hiccup.core)
    > (html [:p "hello World"])
    ;; => "<p>hello World</p>"

    > (pull 'hiccup "1.0.1")
    ;; => {[org.clojure/clojure "1.2.1"] nil, [hiccup "1.0.1"] #{[org.clojure/clojure "1.2.1"]}}

### lein


### inject

`inject` allows easy customisation of your clojure.core namespace by allowing injecting of the functions that you have always wanted to have in your `profiles.clj` file.


## Customisations
    {:user {:plugins [...]
      
             :dependencies [[spyscope "0.1.4"]
                            [org.clojure/tools.namespace "0.2.4"]
                            [io.aviso/pretty "0.1.8"]
                            [im.chit/vinyasa "0.1.0"]]
             :injections [(require 'spyscope.core)
                          
                          (require 'vinyasa.inject)            
                          (vinyasa.inject/inject 'clojure.core '>
                            '[[vinyasa.inject [inject inject]]
                              [vinyasa.pull [pull pull]]
                              [vinyasa.lein [lein lein]]
                              [clojure.repl apropos dir doc find-doc source 
                                            [root-cause >cause]]
                              [clojure.tools.namespace.repl [refresh refresh]]
                              [clojure.pprint pprint]
                              [io.aviso.binary [write-binary >bin]]
                              [io.aviso.repl [pretty-pst >pst]]])
                              
                              
                          (require 'io.aviso.repl 
                                   'clojure.repl 
                                   'clojure.main)
                          (alter-var-root #'clojure.main/repl-caught
                            (constantly @#'io.aviso.repl/pretty-pst))
                          (alter-var-root #'clojure.repl/pst
                            (constantly @#'io.aviso.repl/pretty-pst))]}}

## License

Copyright © 2013 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
