(ns vinyasa.lein
  (:require [clojure.java.io :as io]
            [clojure.walk :refer [postwalk]]
            [clojure.repl :refer [source-fn]]
            [cemerick.pomegranate :as pom]))

(def lein-jar-path
  (-> (.get (System/getenv) "CLASSPATH")
      (clojure.string/split #":")
      (->> (filter #(re-find #"leiningen-.*-standalone.jar" %)))
      (first)))

;;(pom/add-classpath lein-jar-path)
(require '[leiningen.core.main :as lein]
         '[leiningen.core.user :as user]
         '[leiningen.core.project :as project])

(def lein-main-form
  (postwalk
   (fn [f]
     (cond (and (list? f) (= 'exit (first f))) nil
           (list? f) (filter (comp not nil?) f)
           :else f))
   (read-string (source-fn 'leiningen.core.main/-main))))

(in-ns 'leiningen.core.main)
(eval vinyasa.lein/lein-main-form)
(in-ns 'vinyasa.lein)

(defmacro lein [& args]
  `(leiningen.core.main/-main ~@(map str args)))
