/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dsyrk;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlange;
import org.netlib.lapack.Dlansy;

public class DgelsTest {
    public static void main(String[] stringArray) {
        int n = 100;
        for (int i = 0; i < n; ++i) {
            DgelsTest.test(stringArray);
        }
        System.out.println("ALL FINISHED");
    }

    public static void test(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 5) {
            System.out.println(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DgelsTest M N LDA NRHS LDB with \n - M : number of rows of the matrix A \n - N : number of columns of the matrix A \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the matrix B");
            System.exit(1);
        }
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = Integer.parseInt(stringArray[1]);
        int n5 = Integer.parseInt(stringArray[2]);
        int n6 = Integer.parseInt(stringArray[3]);
        int n7 = Integer.parseInt(stringArray[4]);
        double[] dArray = new double[n5 * n4];
        double[] dArray2 = new double[n5 * n4];
        double[] dArray3 = new double[n3 * n3];
        double[] dArray4 = new double[n7 * n6];
        double[] dArray5 = new double[n7 * n6];
        Dplasma.plasma_Init(n3, n4, n6);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                double d = 0.5 - Math.random();
                dArray2[n5 * n + n2] = d;
                dArray[n5 * n + n2] = d;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n3 * n2 + n2] = 1.0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n6; ++n) {
                double d = 0.5 - Math.random();
                dArray5[n7 * n + n2] = d;
                dArray4[n7 * n + n2] = d;
            }
        }
        double[] dArray6 = Dplasma.plasma_Allocate_T(n3, n4);
        Dplasma.plasma_DGELS(111, n3, n4, n6, dArray2, 0, n5, dArray6, 0, dArray5, 0, n7);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n4, n6);
        Dplasma.plasma_DORMQR(141, 111, n3, n3, n4, dArray2, 0, n5, dArray6, 0, dArray3, 0, n3);
        double d = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGELS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n4));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n8 = DgelsTest.check_orthogonality(n3, dArray3, d);
        int n9 = DgelsTest.check_factorization(n3, n4, dArray, dArray2, n5, dArray3, d);
        int n10 = DgelsTest.check_solution(n3, n4, n6, dArray, n5, dArray4, dArray5, n7, d);
        if (n10 == 0 & n9 == 0 & n8 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGELS .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGELS .... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                double d2 = 0.5 - Math.random();
                dArray2[n5 * n + n2] = d2;
                dArray[n5 * n + n2] = d2;
            }
        }
        dArray3 = new double[n3 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n3 * n2 + n2] = 1.0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n6; ++n) {
                double d3 = 0.5 - Math.random();
                dArray5[n7 * n + n2] = d3;
                dArray4[n7 * n + n2] = d3;
            }
        }
        dArray6 = Dplasma.plasma_Allocate_T(n3, n4);
        Dplasma.plasma_DGEQRF(n3, n4, dArray2, 0, n5, dArray6, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n4, n6);
        Dplasma.plasma_DORMQR(141, 111, n3, n3, n4, dArray2, 0, n5, dArray6, 0, dArray3, 0, n3);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n4, n6);
        Dplasma.plasma_DORMQR(141, 111, n3, n6, n4, dArray2, 0, n5, dArray6, 0, dArray5, 0, n7);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n4, n6);
        Dplasma.plasma_DTRSM(141, 121, 111, 131, n4, n6, dArray2, 0, n5, dArray5, 0, n7);
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGEQRF + DORMQR + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n4));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        n8 = DgelsTest.check_orthogonality(n3, dArray3, d);
        n9 = DgelsTest.check_factorization(n3, n4, dArray, dArray2, n5, dArray3, d);
        n10 = DgelsTest.check_solution(n3, n4, n6, dArray, n5, dArray4, dArray5, n7, d);
        if (n10 == 0 & n9 == 0 & n8 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGEQRF + DORMQR + DTRSM .... FAILED !\n");
            System.out.print("************************************************\n");
        }
        Dplasma.plasma_Finalize();
    }

    private static int check_orthogonality(int n, double[] dArray, double d) {
        int n2;
        String string = "I";
        double[] dArray2 = new double[n];
        double d2 = 1.0;
        double d3 = -1.0;
        double[] dArray3 = new double[n * n];
        for (int i = 0; i < n; ++i) {
            dArray3[i * n + i] = 1.0;
        }
        Dsyrk.dsyrk((String)"U", (String)"N", (int)n, (int)n, (double)d2, (double[])dArray, (int)0, (int)n, (double)d3, (double[])dArray3, (int)0, (int)n);
        double d4 = Dlansy.dlansy((String)string, (String)Dplasma.lapack_const(121), (int)n, (double[])dArray3, (int)0, (int)n, (double[])dArray2, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the orthogonality of Q \n");
        System.out.print(String.format("||Id-Q'*Q||_oo / (N*eps) = %e\n", d4 / ((double)n * d)));
        if (d4 / ((double)n * d) > 10.0) {
            System.out.print("-- Orthogonality is suspicious ! \n");
            n2 = 1;
        } else {
            System.out.print("-- Orthogonality is CORRECT ! \n");
            n2 = 0;
        }
        return n2;
    }

    private static int check_factorization(int n, int n2, double[] dArray, double[] dArray2, int n3, double[] dArray3, double d) {
        int n4;
        String string = "I";
        double[] dArray4 = new double[n * n2];
        double[] dArray5 = new double[n * n2];
        double[] dArray6 = new double[n];
        double d2 = 1.0;
        double d3 = 0.0;
        double[] dArray7 = new double[n * n2];
        Dlacpy.dlacpy((String)"U", (int)n, (int)n2, (double[])dArray2, (int)0, (int)n3, (double[])dArray7, (int)0, (int)n);
        dArray4 = new double[n * n2];
        Dgemm.dgemm((String)"T", (String)"N", (int)n, (int)n2, (int)n, (double)d2, (double[])dArray3, (int)0, (int)n, (double[])dArray7, (int)0, (int)n, (double)d3, (double[])dArray4, (int)0, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray5[j * n + i] = dArray[j * n3 + i] - dArray4[j * n + i];
            }
        }
        double d4 = Dlange.dlange((String)string, (int)n, (int)n2, (double[])dArray5, (int)0, (int)n, (double[])dArray6, (int)0);
        double d5 = Dlange.dlange((String)string, (int)n, (int)n2, (double[])dArray2, (int)0, (int)n3, (double[])dArray6, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the QR Factorization \n");
        System.out.print(String.format("-- ||A-QR||_oo/(||A||_oo.N.eps) = %e \n", d4 / (d5 * (double)n2 * d)));
        if (d4 / (d5 * (double)n2 * d) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            n4 = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            n4 = 0;
        }
        return n4;
    }

    private static int check_solution(int n, int n2, int n3, double[] dArray, int n4, double[] dArray2, double[] dArray3, int n5, double d) {
        int n6;
        String string = "I";
        double[] dArray4 = new double[n];
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = Dlange.dlange((String)string, (int)n, (int)n2, (double[])dArray, (int)0, (int)n4, (double[])dArray4, (int)0);
        double d5 = Dlange.dlange((String)string, (int)n, (int)n3, (double[])dArray3, (int)0, (int)n5, (double[])dArray4, (int)0);
        double d6 = Dlange.dlange((String)string, (int)n, (int)n3, (double[])dArray2, (int)0, (int)n5, (double[])dArray4, (int)0);
        Dgemm.dgemm((String)"N", (String)"N", (int)n, (int)n3, (int)n2, (double)d2, (double[])dArray, (int)0, (int)n4, (double[])dArray3, (int)0, (int)n5, (double)d3, (double[])dArray2, (int)0, (int)n5);
        double[] dArray5 = new double[n * n3];
        Dgemm.dgemm((String)"T", (String)"N", (int)n2, (int)n3, (int)n, (double)d2, (double[])dArray, (int)0, (int)n4, (double[])dArray2, (int)0, (int)n5, (double)d3, (double[])dArray5, (int)0, (int)n);
        double d7 = Dlange.dlange((String)string, (int)n, (int)n3, (double[])dArray5, (int)0, (int)n, (double[])dArray4, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||)_oo.N.eps) = %e \n", d7 / ((d4 * d5 + d6) * (double)n2 * d)));
        if (d7 / ((d4 * d5 + d6) * (double)n2 * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n6 = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n6 = 0;
        }
        return n6;
    }
}

