/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDHT_1D {
    private int n;
    private FloatFFT_1D fft;

    public FloatDHT_1D(int n) {
        this.n = n;
        this.fft = new FloatFFT_1D(n);
    }

    public void forward(float[] fArray) {
        this.forward(fArray, 0);
    }

    public void forward(final float[] fArray, final int n) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(fArray, n);
        final float[] fArray2 = new float[this.n];
        System.arraycopy(fArray, n, fArray2, 0, this.n);
        int n2 = this.n / 2;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n3 = 2;
            int n4 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (int i = 0; i < n3; ++i) {
                final int n5 = 1 + i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            fArray[n + i] = fArray2[n3] - fArray2[n2];
                            fArray[n + ((FloatDHT_1D)FloatDHT_1D.this).n - i] = fArray2[n3] + fArray2[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            for (int i = 1; i < n2; ++i) {
                int n7 = 2 * i;
                int n8 = n7 + 1;
                fArray[n + i] = fArray2[n7] - fArray2[n8];
                fArray[n + this.n - i] = fArray2[n7] + fArray2[n8];
            }
        }
        if (this.n % 2 == 0) {
            fArray[n + n2] = fArray2[1];
        } else {
            fArray[n + n2] = fArray2[this.n - 1] - fArray2[1];
            fArray[n + n2 + 1] = fArray2[this.n - 1] + fArray2[1];
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        this.forward(fArray, n);
        if (bl) {
            this.scale(this.n, fArray, n);
        }
    }

    private void scale(float f, final float[] fArray, int n) {
        final float f2 = (float)(1.0 / (double)f);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n2 = 2;
            int n3 = this.n / n2;
            Future[] futureArray = new Future[n2];
            for (int i = 0; i < n2; ++i) {
                final int n4 = n + i * n3;
                final int n5 = i == n2 - 1 ? n + this.n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int n = n4;
                        while (n < n5) {
                            int n2 = n++;
                            fArray[n2] = fArray[n2] * f2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futureArray);
        } else {
            int n6 = n + this.n;
            int n7 = n;
            while (n7 < n6) {
                int n8 = n7++;
                fArray[n8] = fArray[n8] * f2;
            }
        }
    }
}

