/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tdouble;

import cern.colt.PersistentObject;
import cern.colt.buffer.tdouble.DoubleBufferConsumer;
import cern.colt.list.tdouble.DoubleArrayList;

public class DoubleBuffer
extends PersistentObject
implements DoubleBufferConsumer {
    protected DoubleBufferConsumer target;
    protected double[] elements;
    protected DoubleArrayList list;
    protected int capacity;
    protected int size;

    public DoubleBuffer(DoubleBufferConsumer doubleBufferConsumer, int n) {
        this.target = doubleBufferConsumer;
        this.capacity = n;
        this.elements = new double[n];
        this.list = new DoubleArrayList(this.elements);
        this.size = 0;
    }

    public void add(double d) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = d;
    }

    public void addAllOf(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(doubleArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

