/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tfloat;

import cern.colt.PersistentObject;
import cern.colt.buffer.tfloat.FloatBuffer2DConsumer;
import cern.colt.list.tfloat.FloatArrayList;

public class FloatBuffer2D
extends PersistentObject
implements FloatBuffer2DConsumer {
    protected FloatBuffer2DConsumer target;
    protected float[] xElements;
    protected float[] yElements;
    protected FloatArrayList xList;
    protected FloatArrayList yList;
    protected int capacity;
    protected int size;

    public FloatBuffer2D(FloatBuffer2DConsumer floatBuffer2DConsumer, int n) {
        this.target = floatBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new float[n];
        this.yElements = new float[n];
        this.xList = new FloatArrayList(this.xElements);
        this.yList = new FloatArrayList(this.yElements);
        this.size = 0;
    }

    public void add(float f, float f2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = f;
        this.yElements[this.size++] = f2;
    }

    public void addAllOf(FloatArrayList floatArrayList, FloatArrayList floatArrayList2) {
        int n = floatArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(floatArrayList, floatArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

