/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tfloat;

import cern.colt.PersistentObject;
import cern.colt.buffer.tfloat.FloatBuffer3DConsumer;
import cern.colt.list.tfloat.FloatArrayList;

public class FloatBuffer3D
extends PersistentObject
implements FloatBuffer3DConsumer {
    protected FloatBuffer3DConsumer target;
    protected float[] xElements;
    protected float[] yElements;
    protected float[] zElements;
    protected FloatArrayList xList;
    protected FloatArrayList yList;
    protected FloatArrayList zList;
    protected int capacity;
    protected int size;

    public FloatBuffer3D(FloatBuffer3DConsumer floatBuffer3DConsumer, int n) {
        this.target = floatBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new float[n];
        this.yElements = new float[n];
        this.zElements = new float[n];
        this.xList = new FloatArrayList(this.xElements);
        this.yList = new FloatArrayList(this.yElements);
        this.zList = new FloatArrayList(this.zElements);
        this.size = 0;
    }

    public void add(float f, float f2, float f3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = f;
        this.yElements[this.size] = f2;
        this.zElements[this.size++] = f3;
    }

    public void addAllOf(FloatArrayList floatArrayList, FloatArrayList floatArrayList2, FloatArrayList floatArrayList3) {
        int n = floatArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(floatArrayList, floatArrayList2, floatArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

