/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tint;

import cern.colt.PersistentObject;
import cern.colt.buffer.tint.IntBuffer2DConsumer;
import cern.colt.list.tint.IntArrayList;

public class IntBuffer2D
extends PersistentObject
implements IntBuffer2DConsumer {
    protected IntBuffer2DConsumer target;
    protected int[] xElements;
    protected int[] yElements;
    protected IntArrayList xList;
    protected IntArrayList yList;
    protected int capacity;
    protected int size;

    public IntBuffer2D(IntBuffer2DConsumer intBuffer2DConsumer, int n) {
        this.target = intBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new int[n];
        this.yElements = new int[n];
        this.xList = new IntArrayList(this.xElements);
        this.yList = new IntArrayList(this.yElements);
        this.size = 0;
    }

    public void add(int n, int n2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = n;
        this.yElements[this.size++] = n2;
    }

    public void addAllOf(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n = intArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(intArrayList, intArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

