/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tint;

import cern.colt.PersistentObject;
import cern.colt.buffer.tint.IntBuffer3DConsumer;
import cern.colt.list.tint.IntArrayList;

public class IntBuffer3D
extends PersistentObject
implements IntBuffer3DConsumer {
    protected IntBuffer3DConsumer target;
    protected int[] xElements;
    protected int[] yElements;
    protected int[] zElements;
    protected IntArrayList xList;
    protected IntArrayList yList;
    protected IntArrayList zList;
    protected int capacity;
    protected int size;

    public IntBuffer3D(IntBuffer3DConsumer intBuffer3DConsumer, int n) {
        this.target = intBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new int[n];
        this.yElements = new int[n];
        this.zElements = new int[n];
        this.xList = new IntArrayList(this.xElements);
        this.yList = new IntArrayList(this.yElements);
        this.zList = new IntArrayList(this.zElements);
        this.size = 0;
    }

    public void add(int n, int n2, int n3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = n;
        this.yElements[this.size] = n2;
        this.zElements[this.size++] = n3;
    }

    public void addAllOf(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        int n = intArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(intArrayList, intArrayList2, intArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

