/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tdouble;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.AbstractDoubleList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.util.Date;

public class DoubleArrayList
extends AbstractDoubleList {
    protected double[] elements;

    public DoubleArrayList() {
        this(10);
    }

    public DoubleArrayList(double[] dArray) {
        this.elements(dArray);
    }

    public DoubleArrayList(int n) {
        this(new double[n]);
        this.setSizeRaw(0);
    }

    public void add(double d) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = d;
    }

    public void beforeInsert(int n, double d) {
        if (this.size == n) {
            this.add(d);
            return;
        }
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = d;
        ++this.size;
    }

    public int binarySearchFromTo(double d, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, d, n, n2);
    }

    public Object clone() {
        DoubleArrayList doubleArrayList = new DoubleArrayList((double[])this.elements.clone());
        doubleArrayList.setSizeRaw(this.size);
        return doubleArrayList;
    }

    public DoubleArrayList copy() {
        return (DoubleArrayList)this.clone();
    }

    public double[] elements() {
        return this.elements;
    }

    public AbstractDoubleList elements(double[] dArray) {
        this.elements = dArray;
        this.size = dArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)object;
        if (this.size() != doubleArrayList.size()) {
            return false;
        }
        double[] dArray = this.elements();
        double[] dArray2 = doubleArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (dArray[n] == dArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        double[] dArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (doubleProcedure.apply(dArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public double get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public double getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(double d, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        DoubleArrayList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = this.elements;
        for (int i = n; i <= n2; ++i) {
            if (d != dArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(double d, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        DoubleArrayList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = this.elements;
        for (int i = n2; i >= n; --i) {
            if (d != dArray[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractDoubleList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new DoubleArrayList(0);
        }
        DoubleArrayList.checkRangeFromTo(n, n2, this.size);
        double[] dArray = new double[n2 - n + 1];
        System.arraycopy(this.elements, n, dArray, 0, n2 - n + 1);
        return new DoubleArrayList(dArray);
    }

    public boolean removeAll(AbstractDoubleList abstractDoubleList) {
        double d;
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            return super.removeAll(abstractDoubleList);
        }
        if (abstractDoubleList.size() == 0) {
            return false;
        }
        int n = abstractDoubleList.size() - 1;
        int n2 = 0;
        double[] dArray = this.elements;
        int n3 = this.size();
        double d2 = abstractDoubleList.size();
        if ((d2 + (d = (double)n3)) * DoubleArithmetic.log2(d2) < d * d2) {
            DoubleArrayList doubleArrayList = (DoubleArrayList)abstractDoubleList.clone();
            doubleArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (doubleArrayList.binarySearchFromTo(dArray[i], 0, n) >= 0) continue;
                dArray[n2++] = dArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractDoubleList.indexOfFromTo(dArray[i], 0, n) >= 0) continue;
                dArray[n2++] = dArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractDoubleList abstractDoubleList, int n3) {
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractDoubleList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            DoubleArrayList.checkRangeFromTo(n, n2, this.size());
            DoubleArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractDoubleList.size());
            System.arraycopy(((DoubleArrayList)abstractDoubleList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractDoubleList abstractDoubleList) {
        double d;
        if (!(abstractDoubleList instanceof DoubleArrayList)) {
            return super.retainAll(abstractDoubleList);
        }
        int n = abstractDoubleList.size() - 1;
        int n2 = 0;
        double[] dArray = this.elements;
        int n3 = this.size();
        double d2 = abstractDoubleList.size();
        if ((d2 + (d = (double)n3)) * DoubleArithmetic.log2(d2) < d * d2) {
            DoubleArrayList doubleArrayList = (DoubleArrayList)abstractDoubleList.clone();
            doubleArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (doubleArrayList.binarySearchFromTo(dArray[i], 0, n) < 0) continue;
                dArray[n2++] = dArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractDoubleList.indexOfFromTo(dArray[i], 0, n) < 0) continue;
                dArray[n2++] = dArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        double[] dArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            double d = dArray[n3];
            dArray[n3++] = dArray[n2];
            dArray[n2--] = d;
        }
    }

    public void set(int n, double d) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = d;
    }

    public void setSizeRaw(int n) {
        this.size = n;
    }

    public void setQuick(int n, double d) {
        this.elements[n] = d;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        DoubleArrayList.checkRangeFromTo(n, n2, this.size);
        DoubleUniform doubleUniform = new DoubleUniform(new DRand(new Date()));
        double[] dArray = this.elements;
        for (int i = n; i < n2; ++i) {
            int n3 = doubleUniform.nextIntFromTo(i, n2);
            double d = dArray[n3];
            dArray[n3] = dArray[i];
            dArray[i] = d;
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

