/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tdouble;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.LongDoubleProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.tdouble.AbstractDoubleMap;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public abstract class AbstractLongDoubleMap
extends AbstractDoubleMap {
    protected AbstractLongDoubleMap() {
    }

    public void assign(final DoubleFunction doubleFunction) {
        this.copy().forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d) {
                AbstractLongDoubleMap.this.put(l, doubleFunction.apply(d));
                return true;
            }
        });
    }

    public void assign(AbstractLongDoubleMap abstractLongDoubleMap) {
        this.clear();
        abstractLongDoubleMap.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d) {
                AbstractLongDoubleMap.this.put(l, d);
                return true;
            }
        });
    }

    public boolean containsKey(final long l) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long l2) {
                return l != l2;
            }
        });
    }

    public boolean containsValue(final double d) {
        return !this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d2) {
                return d != d2;
            }
        });
    }

    public AbstractLongDoubleMap copy() {
        return (AbstractLongDoubleMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractLongDoubleMap)) {
            return false;
        }
        final AbstractLongDoubleMap abstractLongDoubleMap = (AbstractLongDoubleMap)object;
        if (abstractLongDoubleMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d) {
                return abstractLongDoubleMap.containsKey(l) && abstractLongDoubleMap.get(l) == d;
            }
        }) && abstractLongDoubleMap.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d) {
                return AbstractLongDoubleMap.this.containsKey(l) && AbstractLongDoubleMap.this.get(l) == d;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongDoubleProcedure longDoubleProcedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                return longDoubleProcedure.apply(l, AbstractLongDoubleMap.this.get(l));
            }
        });
    }

    public abstract double get(long var1);

    public long keyOf(final double d) {
        final long[] lArray = new long[1];
        boolean bl = this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d2) {
                boolean bl;
                boolean bl2 = bl = d == d2;
                if (bl) {
                    lArray[0] = l;
                }
                return !bl;
            }
        });
        if (bl) {
            return Long.MIN_VALUE;
        }
        return lArray[0];
    }

    public LongArrayList keys() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.keys(longArrayList);
        return longArrayList;
    }

    public void keys(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                longArrayList.add(l);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList longArrayList) {
        this.pairsSortedByValue(longArrayList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final LongDoubleProcedure longDoubleProcedure, final LongArrayList longArrayList, final DoubleArrayList doubleArrayList) {
        longArrayList.clear();
        doubleArrayList.clear();
        this.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d) {
                if (longDoubleProcedure.apply(l, d)) {
                    longArrayList.add(l);
                    doubleArrayList.add(d);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList longArrayList, DoubleArrayList doubleArrayList) {
        this.keys(longArrayList);
        longArrayList.sort();
        int n = longArrayList.size();
        doubleArrayList.setSize(n);
        final double[] dArray = doubleArrayList.elements();
        final long[] lArray = longArrayList.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = n - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            dArray[n] = AbstractLongDoubleMap.this.get(lArray[n]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = longArrayList.size();
            while (--n6 >= 0) {
                dArray[n6] = this.get(lArray[n6]);
            }
        }
    }

    public void pairsSortedByValue(LongArrayList longArrayList, DoubleArrayList doubleArrayList) {
        this.keys(longArrayList);
        this.values(doubleArrayList);
        final long[] lArray = longArrayList.elements();
        final double[] dArray = doubleArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return dArray[n] < dArray[n2] ? -1 : (dArray[n] > dArray[n2] ? 1 : (lArray[n] < lArray[n2] ? -1 : (lArray[n] == lArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, longArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(long var1, double var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList longArrayList = this.keys();
        String string = longArrayList.toString() + "\n";
        longArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        LongArrayList longArrayList = new LongArrayList();
        this.keysSortedByValue(longArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.size());
        this.values(doubleArrayList);
        return doubleArrayList;
    }

    public void values(final DoubleArrayList doubleArrayList) {
        doubleArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                doubleArrayList.add(AbstractLongDoubleMap.this.get(l));
                return true;
            }
        });
    }
}

