/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.PersistentObject;
import cern.colt.map.PrimeFinder;

public abstract class AbstractFloatMap
extends PersistentObject {
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected float minLoadFactor;
    protected float maxLoadFactor;
    protected static final int defaultCapacity = 277;
    protected static final float defaultMinLoadFactor = 0.2f;
    protected static final float defaultMaxLoadFactor = 0.5f;

    protected AbstractFloatMap() {
    }

    protected int chooseGrowCapacity(int n, float f, float f2) {
        return this.nextPrime(Math.max(n + 1, (int)((float)(4 * n) / (3.0f * f + f2))));
    }

    protected int chooseHighWaterMark(int n, float f) {
        return Math.min(n - 2, (int)((float)n * f));
    }

    protected int chooseLowWaterMark(int n, float f) {
        return (int)((float)n * f);
    }

    protected int chooseMeanCapacity(int n, float f, float f2) {
        return this.nextPrime(Math.max(n + 1, (int)((float)(2 * n) / (f + f2))));
    }

    protected int chooseShrinkCapacity(int n, float f, float f2) {
        return this.nextPrime(Math.max(n + 1, (int)((float)(4 * n) / (f + 3.0f * f2))));
    }

    public abstract void clear();

    public void ensureCapacity(int n) {
    }

    public boolean isEmpty() {
        return this.distinct == 0;
    }

    protected int nextPrime(int n) {
        return PrimeFinder.nextPrime(n);
    }

    protected void setUp(int n, float f, float f2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + n);
        }
        if ((double)f < 0.0 || (double)f >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + f);
        }
        if ((double)f2 <= 0.0 || (double)f2 >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + f2);
        }
        if (f >= f2) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + f + " and maxLoadFactor: " + f2);
        }
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
    }
}

