/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.Sorting;
import cern.colt.Timer;
import cern.colt.function.tdouble.Double9Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tdouble.AbstractIntDoubleMap;
import cern.colt.map.tdouble.OpenIntDoubleHashMap;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleFactory3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleMatrix2DComparator;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleStatistic;
import cern.colt.matrix.tdouble.algo.SmpDoubleBlas;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleLUDecompositionQuick;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.TridiagonalDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.Normal;
import cern.jet.random.tdouble.Poisson;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import hep.aida.tdouble.bin.DynamicDoubleBin1D;

class TestMatrix2D {
    private static final DoubleFunctions F = DoubleFunctions.functions;
    private static final DoubleFactory2D Factory2D = DoubleFactory2D.dense;
    private static final DoubleFactory1D Factory1D = DoubleFactory1D.dense;
    private static final DoubleAlgebra LinearAlgebra = DoubleAlgebra.DEFAULT;
    private static final DoubleProperty Property = DoubleProperty.DEFAULT;

    protected TestMatrix2D() {
        throw new RuntimeException("Non instantiable");
    }

    public static void doubleTest() {
        int n = 4;
        int n2 = 5;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        System.out.println(denseDoubleMatrix2D);
        ((DoubleMatrix2D)denseDoubleMatrix2D).assign(1.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        denseDoubleMatrix2D.viewPart(2, 1, 2, 3).assign(2.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewPart(2, 1, 2, 3).copy();
        doubleMatrix2D.assign(3.0);
        doubleMatrix2D.set(0, 0, 4.0);
        System.out.println("\n" + doubleMatrix2D);
        System.out.println("\n" + denseDoubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D.viewPart(0, 3, 4, 2);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewPart(0, 0, 4, 1);
        System.out.println("\n" + doubleMatrix2D2);
        System.out.println("\n" + doubleMatrix2D3);
    }

    public static void doubleTest(int n, int n2, int n3, double d, double d2) {
        int n4;
        int n5;
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(n, n2, n3, d, d2);
        System.out.println(sparseDoubleMatrix2D);
        System.out.println("adding...");
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                sparseDoubleMatrix2D.set(n4, n5, n6);
                ++n6;
            }
        }
        System.out.println(sparseDoubleMatrix2D);
        System.out.println("removing...");
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                sparseDoubleMatrix2D.set(n4, n5, 0.0);
            }
        }
        System.out.println(sparseDoubleMatrix2D);
        System.out.println("bye bye.");
    }

    public static void doubleTest10() {
        int n = 6;
        int n2 = 7;
        DoubleMatrix2D doubleMatrix2D = Factory2D.ascending(n, n2);
        doubleMatrix2D.assign(DoubleFunctions.mult(Math.sin(0.3)));
        System.out.println("\n" + doubleMatrix2D);
        int[] nArray = new int[]{0, 1, 2, 3};
        int[] nArray2 = new int[]{0, 1, 2, 3};
        int[] nArray3 = new int[]{3, 0, 3};
        int[] nArray4 = new int[]{3, 0, 3};
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewPart(1, 1, 4, 5).viewSelection(nArray, nArray2);
        System.out.println("\nview1=" + doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewStrides(2, 2).viewStrides(2, 1);
        System.out.println("\nview9=" + doubleMatrix2D3);
        doubleMatrix2D2 = doubleMatrix2D2.viewSelection(nArray3, nArray4);
        System.out.println("\nview1=" + doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D2.viewPart(1, 1, 2, 2);
        System.out.println("\nview2=" + doubleMatrix2D4);
        DoubleMatrix2D doubleMatrix2D5 = doubleMatrix2D4.viewRowFlip();
        System.out.println("\nview3=" + doubleMatrix2D5);
        doubleMatrix2D5.assign(Factory2D.ascending(doubleMatrix2D5.rows(), doubleMatrix2D5.columns()));
        System.out.println("\nview3=" + doubleMatrix2D5);
        System.out.println("\nmaster replaced" + doubleMatrix2D);
        System.out.println("\nview1 replaced" + doubleMatrix2D2);
        System.out.println("\nview2 replaced" + doubleMatrix2D4);
        System.out.println("\nview3 replaced" + doubleMatrix2D5);
    }

    public static void doubleTest11() {
        int n = 4;
        int n2 = 5;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(1, 1);
        ((DoubleMatrix2D)denseDoubleMatrix2D).assign(2.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n2];
        DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewSelection(nArray, nArray2);
        System.out.println(doubleMatrix2D);
        ((DoubleMatrix2D)denseDoubleMatrix2D).assign(1.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        System.out.println(doubleMatrix2D);
    }

    public static void doubleTest12() {
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(2, 3, 9.0);
        DoubleMatrix2D doubleMatrix2D2 = Factory2D.make(4, 3, 8.0);
        DoubleMatrix2D doubleMatrix2D3 = Factory2D.appendRows(doubleMatrix2D, doubleMatrix2D2);
        System.out.println("\nA=" + doubleMatrix2D);
        System.out.println("\nB=" + doubleMatrix2D2);
        System.out.println("\nC=" + doubleMatrix2D3);
        DoubleMatrix2D doubleMatrix2D4 = Factory2D.make(3, 2, 7.0);
        DoubleMatrix2D doubleMatrix2D5 = Factory2D.make(3, 4, 6.0);
        DoubleMatrix2D doubleMatrix2D6 = Factory2D.appendColumns(doubleMatrix2D4, doubleMatrix2D5);
        System.out.println("\nD=" + doubleMatrix2D4);
        System.out.println("\nE=" + doubleMatrix2D5);
        System.out.println("\nF=" + doubleMatrix2D6);
        DoubleMatrix2D doubleMatrix2D7 = Factory2D.appendRows(doubleMatrix2D3, doubleMatrix2D6);
        System.out.println("\nG=" + doubleMatrix2D7);
        DoubleMatrix2D doubleMatrix2D8 = Factory2D.ascending(2, 3);
        System.out.println("\nH=" + doubleMatrix2D8);
        DoubleMatrix2D doubleMatrix2D9 = Factory2D.repeat(doubleMatrix2D8, 2, 3);
        System.out.println("\nI=" + doubleMatrix2D9);
    }

    public static void doubleTest13() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0};
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        System.out.println(denseDoubleMatrix1D);
        System.out.println(denseDoubleMatrix1D.viewSelection(new DoubleProcedure(){

            public final boolean apply(double d) {
                return d % 2.0 == 0.0;
            }
        }));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.plus, DoubleFunctions.square));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.plus, DoubleFunctions.pow(3.0)));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.plus, DoubleFunctions.identity));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.min, DoubleFunctions.identity));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.max, DoubleFunctions.chain(DoubleFunctions.div(2.0), DoubleFunctions.sqrt)));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.plus, DoubleFunctions.between(0.0, 2.0)));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.between(0.8, 1.2), DoubleFunctions.log2)));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.mult, DoubleFunctions.identity));
        DoubleFunction doubleFunction = new DoubleFunction(){

            public final double apply(double d) {
                return d > 1.0 ? d : 1.0;
            }
        };
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(DoubleFunctions.mult, doubleFunction));
        DoubleMatrix1D doubleMatrix1D = denseDoubleMatrix1D.copy();
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(doubleMatrix1D, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.square, DoubleFunctions.plus)));
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.plus(1.0));
        doubleMatrix1D = denseDoubleMatrix1D.copy();
        System.out.println(denseDoubleMatrix1D);
        System.out.println(doubleMatrix1D);
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(doubleMatrix1D, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.mult(Math.PI), DoubleFunctions.chain(DoubleFunctions.log, DoubleFunctions.swapArgs(DoubleFunctions.div)))));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(doubleMatrix1D, DoubleFunctions.plus, new DoubleDoubleFunction(){

            public double apply(double d, double d2) {
                return Math.PI * Math.log(d2 / d);
            }
        }));
        DoubleMatrix3D doubleMatrix3D = DoubleFactory3D.dense.ascending(2, 2, 2);
        System.out.println(doubleMatrix3D);
        System.out.println(doubleMatrix3D.aggregate(DoubleFunctions.plus, DoubleFunctions.square));
        DoubleMatrix3D doubleMatrix3D2 = doubleMatrix3D.copy();
        System.out.println(doubleMatrix3D.aggregate(doubleMatrix3D2, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.square, DoubleFunctions.plus)));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).assign(F.random()));
        System.out.println(((DoubleMatrix1D)denseDoubleMatrix1D).assign(new Poisson(5.0, Poisson.makeDefaultGenerator())));
    }

    public static void doubleTest14(int n, int n2, int n3) {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0};
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.ascending(n, n2);
        DoubleMatrix2D doubleMatrix2D2 = DoubleFactory2D.dense.ascending(n2, n3).assign(DoubleFunctions.mult(-1.0));
        doubleMatrix2D.assign(0.0);
        doubleMatrix2D2.assign(0.0);
        Timer timer = new Timer().start();
        LinearAlgebra.mult(doubleMatrix2D, doubleMatrix2D2);
        timer.stop().display();
    }

    public static void doubleTest15(int n, int n2) {
        System.out.println("\n\n");
        double[][] dArrayArray = new double[][]{{0.0, 5.0, 9.0}, {2.0, 6.0, 10.0}, {3.0, 7.0, 11.0}};
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(n, n);
        double d = 5.0;
        int n3 = n;
        while (--n3 >= 0) {
            doubleMatrix2D.setQuick(n3, n3, d);
        }
        doubleMatrix2D.viewRow(0).assign(d);
        Timer timer = new Timer().start();
        DoubleMatrix2D doubleMatrix2D2 = null;
        for (int i = 0; i < n2; ++i) {
            doubleMatrix2D2 = LinearAlgebra.inverse(doubleMatrix2D);
        }
        timer.stop().display();
    }

    public static void doubleTest17(int n) {
        System.out.println("\n\n");
        DoubleMatrix2D doubleMatrix2D = Factory2D.ascending(3, 4);
        DoubleMatrix2D doubleMatrix2D2 = Factory2D.ascending(2, 3);
        DoubleMatrix2D doubleMatrix2D3 = Factory2D.ascending(1, 2);
        doubleMatrix2D2.assign(DoubleFunctions.plus(doubleMatrix2D.zSum()));
        doubleMatrix2D3.assign(DoubleFunctions.plus(doubleMatrix2D2.zSum()));
    }

    public static void doubleTest18(int n) {
        System.out.println("\n\n");
        int n2 = 2;
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(0, 0);
        DoubleMatrix2D doubleMatrix2D2 = Factory2D.ascending(n2, n2);
        DoubleMatrix2D doubleMatrix2D3 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D2.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D4 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D3.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D5 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D4.getQuick(n2 - 1, n2 - 1)));
        Object var6_7 = null;
        DoubleMatrix2D doubleMatrix2D6 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D5.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D7 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D6.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D8 = doubleMatrix2D;
        DoubleMatrix2D doubleMatrix2D9 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D7.getQuick(n2 - 1, n2 - 1)));
        System.out.println("\n" + doubleMatrix2D2);
        System.out.println("\n" + doubleMatrix2D3);
        System.out.println("\n" + doubleMatrix2D4);
        System.out.println("\n" + doubleMatrix2D5);
        System.out.println("\n" + var6_7);
        System.out.println("\n" + doubleMatrix2D6);
        System.out.println("\n" + doubleMatrix2D7);
        System.out.println("\n" + doubleMatrix2D8);
        System.out.println("\n" + doubleMatrix2D9);
    }

    public static void doubleTest19() {
        System.out.println("\n\n");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(dArrayArray);
        int n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        int n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        int n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
        double[][] dArrayArray2 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray2);
        n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
        double[][] dArrayArray3 = new double[][]{{1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray3);
        n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
        double[][] dArrayArray4 = new double[][]{{0.0, 1.0, 1.0, 1.0}, {0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray4);
        n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
        double[][] dArrayArray5 = new double[][]{{0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray5);
        n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
        double[][] dArrayArray6 = new double[][]{{1.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 1.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray6);
        n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
        double[][] dArrayArray7 = new double[][]{{1.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 1.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray7);
        n = DoubleProperty.DEFAULT.semiBandwidth(doubleMatrix2D);
        n2 = DoubleProperty.DEFAULT.upperBandwidth(doubleMatrix2D);
        n3 = DoubleProperty.DEFAULT.lowerBandwidth(doubleMatrix2D);
        System.out.println("\n\nupperBandwidth=" + n2);
        System.out.println("lowerBandwidth=" + n3);
        System.out.println("bandwidth=" + n + " " + doubleMatrix2D);
    }

    public static void doubleTest19(int n) {
        System.out.println("\n\n");
        int n2 = 2;
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(0, 0);
        DoubleMatrix2D doubleMatrix2D2 = Factory2D.ascending(n2, n2);
        DoubleMatrix2D doubleMatrix2D3 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D2.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D4 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D3.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D5 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D4.getQuick(n2 - 1, n2 - 1)));
        Object var6_7 = null;
        DoubleMatrix2D doubleMatrix2D6 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D5.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D7 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D6.getQuick(n2 - 1, n2 - 1)));
        DoubleMatrix2D doubleMatrix2D8 = doubleMatrix2D;
        DoubleMatrix2D doubleMatrix2D9 = Factory2D.ascending(n2, n2).assign(DoubleFunctions.plus(doubleMatrix2D7.getQuick(n2 - 1, n2 - 1)));
        System.out.println("\n" + doubleMatrix2D2);
        System.out.println("\n" + doubleMatrix2D3);
        System.out.println("\n" + doubleMatrix2D4);
        System.out.println("\n" + doubleMatrix2D5);
        System.out.println("\n" + var6_7);
        System.out.println("\n" + doubleMatrix2D6);
        System.out.println("\n" + doubleMatrix2D7);
        System.out.println("\n" + doubleMatrix2D8);
        System.out.println("\n" + doubleMatrix2D9);
    }

    public static void doubleTest2() {
        int[] nArray = new int[]{0, 3, 100000, 9};
        double[] dArray = new double[]{100.0, 1000.0, 70.0, 71.0};
        int n = nArray.length;
        OpenIntDoubleHashMap openIntDoubleHashMap = new OpenIntDoubleHashMap(n * 2, 0.2, 0.5);
        for (int i = 0; i < nArray.length; ++i) {
            ((AbstractIntDoubleMap)openIntDoubleHashMap).put(nArray[i], (int)dArray[i]);
        }
        System.out.println(((AbstractIntDoubleMap)openIntDoubleHashMap).containsKey(3));
        System.out.println(((AbstractIntDoubleMap)openIntDoubleHashMap).get(3));
        System.out.println(((AbstractIntDoubleMap)openIntDoubleHashMap).containsKey(4));
        System.out.println(((AbstractIntDoubleMap)openIntDoubleHashMap).get(4));
        System.out.println(((AbstractIntDoubleMap)openIntDoubleHashMap).containsValue(71.0));
        System.out.println(((AbstractIntDoubleMap)openIntDoubleHashMap).keyOf(71.0));
        System.out.println(openIntDoubleHashMap);
    }

    public static void doubleTest20() {
        System.out.println("\n\n");
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 0.0, 0.0}, {3.0, 0.0, 2.0, 0.0}, {0.0, 2.0, 0.0, 3.0}, {0.0, 0.0, 1.0, 0.0}};
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(dArrayArray);
        System.out.println("\n\n" + LinearAlgebra.toVerboseString(doubleMatrix2D));
        double[][] dArrayArray2 = new double[][]{{1.0000000000000167, -0.3623577544766736, -0.3623577544766736}, {0.0, 0.9320390859672374, -0.3377315902755755}, {0.0, 0.0, 0.8686968577706282}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray2);
        System.out.println("\n\n" + LinearAlgebra.toVerboseString(doubleMatrix2D));
        double[][] dArrayArray3 = new double[][]{{611.0, 196.0, -192.0, 407.0, -8.0, -52.0, -49.0, 29.0}, {196.0, 899.0, 113.0, -192.0, -71.0, -43.0, -8.0, -44.0}, {-192.0, 113.0, 899.0, 196.0, 61.0, 49.0, 8.0, 52.0}, {407.0, -192.0, 196.0, 611.0, 8.0, 44.0, 59.0, -23.0}, {-8.0, -71.0, 61.0, 8.0, 411.0, -599.0, 208.0, 208.0}, {-52.0, -43.0, 49.0, 44.0, -599.0, 411.0, 208.0, 208.0}, {-49.0, -8.0, 8.0, 59.0, 208.0, 208.0, 99.0, -911.0}, {29.0, -44.0, 52.0, -23.0, 208.0, 208.0, -911.0, 99.0}};
        doubleMatrix2D = Factory2D.make(dArrayArray3);
        System.out.println("\n\n" + LinearAlgebra.toVerboseString(doubleMatrix2D));
        double d = Math.sqrt(10405.0);
        double d2 = Math.sqrt(26.0);
        double[] dArray = new double[]{-10.0 * d, 0.0, 510.0 - 100.0 * d2, 1000.0, 1000.0, 510.0 + 100.0 * d2, 1020.0, 10.0 * d};
        System.out.println(DoubleFactory1D.dense.make(dArray));
    }

    public static void doubleTest21() {
        System.out.println("\n\n");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, Math.PI, 0.0}, {3.0, 9.0, 0.0, 0.0}, {0.0, 2.0, 7.0, 0.0}, {0.0, 0.0, 3.0, 9.0}};
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(dArrayArray);
        System.out.println(doubleMatrix2D);
        System.out.println(new DoubleFormatter(null).toString(doubleMatrix2D));
    }

    public static void doubleTest22() {
        System.out.println("\n\n");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, Math.PI, 0.0}, {3.0, 9.0, 0.0, 0.0}, {0.0, 2.0, 7.0, 0.0}, {0.0, 0.0, 3.0, 9.0}};
        DoubleMatrix2D doubleMatrix2D = Factory2D.make(dArrayArray);
        System.out.println(doubleMatrix2D);
        System.out.println(Property.isDiagonallyDominantByRow(doubleMatrix2D));
        System.out.println(Property.isDiagonallyDominantByColumn(doubleMatrix2D));
        Property.generateNonSingular(doubleMatrix2D);
        System.out.println(doubleMatrix2D);
        System.out.println(Property.isDiagonallyDominantByRow(doubleMatrix2D));
        System.out.println(Property.isDiagonallyDominantByColumn(doubleMatrix2D));
    }

    public static void doubleTest23(int n, int n2, double d, boolean bl) {
        System.out.println("\n\n");
        System.out.println("initializing...");
        double d2 = 5.0;
        double d3 = 3.0;
        Normal normal = new Normal(d2, d3, new DoubleMersenneTwister());
        System.out.println("sampling...");
        double d4 = 2.0;
        DoubleMatrix2D doubleMatrix2D = bl ? DoubleFactory2D.dense.sample(n2, n2, d4, d) : DoubleFactory2D.sparse.sample(n2, n2, d4, d);
        DoubleMatrix1D doubleMatrix1D = doubleMatrix2D.like1D(n2).assign(1.0);
        System.out.println("generating invertible matrix...");
        Property.generateNonSingular(doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like();
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        DoubleLUDecompositionQuick doubleLUDecompositionQuick = new DoubleLUDecompositionQuick();
        System.out.println("benchmarking assignment...");
        Timer timer = new Timer().start();
        doubleMatrix2D2.assign(doubleMatrix2D);
        doubleMatrix1D2.assign(doubleMatrix1D);
        timer.stop().display();
        doubleMatrix2D2.assign(doubleMatrix2D);
        doubleLUDecompositionQuick.decompose(doubleMatrix2D2);
        System.out.println("benchmarking LU...");
        timer.reset().start();
        int n3 = n;
        while (--n3 >= 0) {
            doubleMatrix1D2.assign(doubleMatrix1D);
            doubleLUDecompositionQuick.solve(doubleMatrix1D2);
        }
        timer.stop().display();
        System.out.println("done.");
    }

    public static void doubleTest24(int n, int n2, boolean bl) {
        System.out.println("\n\n");
        System.out.println("initializing...");
        DoubleFactory2D doubleFactory2D = bl ? DoubleFactory2D.dense : DoubleFactory2D.sparse;
        double d = 2.0;
        double d2 = 1.25;
        final double d3 = d2 * 0.25;
        final double d4 = 1.0 - d2;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(n2, n2, d);
        Double9Function double9Function = new Double9Function(){

            public final double apply(double d, double d2, double d32, double d42, double d5, double d6, double d7, double d8, double d9) {
                return d3 * d5 + d4 * (d2 + d42 + d6 + d8);
            }
        };
        Timer timer = new Timer().start();
        System.out.println("benchmarking stencil...");
        for (int i = 0; i < n; ++i) {
            doubleMatrix2D.zAssign8Neighbors(doubleMatrix2D, double9Function);
        }
        timer.stop().display();
        doubleMatrix2D = null;
        double[][] dArray = doubleFactory2D.make(n2, n2, d).toArray();
        timer.reset().start();
        System.out.println("benchmarking stencil scimark...");
        for (int i = 0; i < n; ++i) {
        }
        timer.stop().display();
        System.out.println("done.");
    }

    public static void doubleTest25(int n) {
        System.out.println("\n\n");
        System.out.println("initializing...");
        boolean bl = true;
        DoubleFactory2D doubleFactory2D = bl ? DoubleFactory2D.dense : DoubleFactory2D.sparse;
        double d = 0.5;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(n, n, d);
        Property.generateNonSingular(doubleMatrix2D);
        Timer timer = new Timer().start();
        System.out.println(doubleMatrix2D);
        System.out.println(DoubleAlgebra.ZERO.inverse(doubleMatrix2D));
        timer.stop().display();
        System.out.println("done.");
    }

    public static void doubleTest26(int n) {
        System.out.println("\n\n");
        System.out.println("initializing...");
        boolean bl = true;
        DoubleFactory2D doubleFactory2D = bl ? DoubleFactory2D.dense : DoubleFactory2D.sparse;
        double d = 0.5;
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(n, n, d);
        Property.generateNonSingular(doubleMatrix2D);
        Timer timer = new Timer().start();
        DoubleMatrix2DComparator doubleMatrix2DComparator = new DoubleMatrix2DComparator(){

            public int compare(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                return doubleMatrix2D.zSum() == doubleMatrix2D2.zSum() ? 1 : 0;
            }
        };
        System.out.println(doubleMatrix2D);
        System.out.println(DoubleAlgebra.ZERO.inverse(doubleMatrix2D));
        timer.stop().display();
        System.out.println("done.");
    }

    public static void doubleTest27() {
        System.out.println("\n\n");
        System.out.println("initializing...");
        int n = 51;
        int n2 = 10;
        double[][] dArray = new double[n2][n];
        int n3 = n2;
        while (--n3 >= 0) {
            dArray[n3][n3] = 2.0;
        }
        n3 = 0;
        int n4 = 0;
        DoubleMatrix2D doubleMatrix2D = null;
        DoubleMatrix2D doubleMatrix2D2 = null;
        DoubleMatrix2D doubleMatrix2D3 = null;
        DoubleMatrix2D doubleMatrix2D4 = null;
        DoubleMatrix2D doubleMatrix2D5 = null;
        DoubleMatrix2D doubleMatrix2D6 = null;
        doubleMatrix2D = DoubleFactory2D.dense.make(n, n2);
        for (n3 = 0; n3 < n2; ++n3) {
            for (n4 = 0; n4 < n; ++n4) {
                doubleMatrix2D.setQuick(n4, n3, dArray[n3][n4]);
            }
        }
        doubleMatrix2D2 = DoubleAlgebra.DEFAULT.transpose(doubleMatrix2D);
        doubleMatrix2D3 = DoubleAlgebra.DEFAULT.mult(doubleMatrix2D2, doubleMatrix2D);
        doubleMatrix2D4 = DoubleAlgebra.DEFAULT.inverse(doubleMatrix2D3);
        doubleMatrix2D5 = DoubleAlgebra.DEFAULT.mult(doubleMatrix2D4, doubleMatrix2D2);
        doubleMatrix2D6 = DoubleAlgebra.DEFAULT.mult(doubleMatrix2D, doubleMatrix2D5);
        System.out.println("done.");
    }

    public static void doubleTest28() {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, {2.0, 3.0, 4.0, 5.0, 6.0, 7.0}};
        DoubleFactory2D doubleFactory2D = DoubleFactory2D.dense;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray);
        DoubleMatrix1D doubleMatrix1D = ((DoubleMatrix1D)denseDoubleMatrix1D).like(doubleMatrix2D.rows());
        doubleMatrix2D.zMult(denseDoubleMatrix1D, doubleMatrix1D);
        System.out.println(doubleMatrix1D);
    }

    public static void doubleTest28(DoubleFactory2D doubleFactory2D) {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, {2.0, 3.0, 4.0, 5.0, 6.0, 7.0}};
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray);
        DoubleMatrix1D doubleMatrix1D = ((DoubleMatrix1D)denseDoubleMatrix1D).like(doubleMatrix2D.rows());
        doubleMatrix2D.zMult(denseDoubleMatrix1D, doubleMatrix1D);
        System.out.println(doubleMatrix1D);
    }

    public static void doubleTest29(int n) {
    }

    public static void doubleTest29(int n, DoubleFactory2D doubleFactory2D) {
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(n, n).assign(0.5);
        DoubleMatrix2D doubleMatrix2D2 = doubleFactory2D.sample(n, n, 0.5, 0.001);
        Timer timer = new Timer().start();
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.zMult(doubleMatrix2D, null);
        timer.stop().display();
    }

    public static void doubleTest29(DoubleFactory2D doubleFactory2D) {
        double[][] dArrayArray = new double[][]{{6.0, 5.0, 4.0}, {7.0, 6.0, 3.0}, {6.0, 5.0, 4.0}, {7.0, 6.0, 3.0}, {6.0, 5.0, 4.0}, {7.0, 6.0, 3.0}};
        double[][] dArrayArray2 = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, {2.0, 3.0, 4.0, 5.0, 6.0, 7.0}};
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArrayArray);
        DoubleMatrix2D doubleMatrix2D = doubleFactory2D.make(dArrayArray2);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.zMult(denseDoubleMatrix2D, null);
        System.out.println(doubleMatrix2D2);
    }

    public static void doubleTest3() {
        int n = 4;
        int n2 = 5;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        System.out.println(denseDoubleMatrix2D);
        ((DoubleMatrix2D)denseDoubleMatrix2D).assign(1.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        denseDoubleMatrix2D.viewPart(2, 0, 2, 3).assign(2.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewColumnFlip();
        System.out.println("flip around columns=" + doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewRowFlip();
        System.out.println("further flip around rows=" + doubleMatrix2D2);
        doubleMatrix2D2.viewPart(0, 0, 2, 2).assign(3.0);
        System.out.println("master replaced" + denseDoubleMatrix2D);
        System.out.println("flip1 replaced" + doubleMatrix2D);
        System.out.println("flip2 replaced" + doubleMatrix2D2);
    }

    public static void doubleTest30() {
        double[][] dArrayArray = new double[][]{{6.0, 5.0}, {7.0, 6.0}};
        double[] dArray = new double[]{1.0, 2.0};
        double[] dArray2 = new double[]{3.0, 4.0};
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArrayArray);
        SmpDoubleBlas smpDoubleBlas = new SmpDoubleBlas();
        smpDoubleBlas.dger(1.0, new DenseDoubleMatrix1D(dArray), new DenseDoubleMatrix1D(dArray2), denseDoubleMatrix2D);
        System.out.println(denseDoubleMatrix2D);
    }

    public static void doubleTest30(int n) {
        int[] nArray = new int[]{0, 2, 3, 5, 7};
        IntArrayList intArrayList = new IntArrayList(nArray);
        int n2 = 3;
        int n3 = 0;
        Timer timer = new Timer().start();
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = intArrayList.binarySearchFromTo(n2, 0, nArray.length - 1);
            System.out.println(intArrayList + ", " + n2 + " --> " + n5);
            n3 += n5;
        }
        timer.stop().display();
    }

    public static void doubleTest30(int n, int n2) {
        int[] nArray = new int[]{2};
        IntArrayList intArrayList = new IntArrayList(nArray);
        int n3 = nArray.length - 1;
        int n4 = 0;
        Timer timer = new Timer().start();
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = Sorting.binarySearchFromTo(nArray, n2, 0, n3);
            n4 += n6;
        }
        timer.stop().display();
        System.out.println("sum = " + n4);
    }

    public static void doubleTest31(int n) {
        System.out.println("\ninit");
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.descending(n);
        DoubleMatrix1D doubleMatrix1D2 = new WrapperDoubleMatrix1D(doubleMatrix1D);
        DoubleMatrix1D doubleMatrix1D3 = ((DoubleMatrix1D)doubleMatrix1D2).viewPart(2, 3);
        DoubleMatrix1D doubleMatrix1D4 = doubleMatrix1D3.viewFlip();
        doubleMatrix1D4.set(0, 99.0);
        doubleMatrix1D2 = doubleMatrix1D2.viewSorted();
        System.out.println("a = " + doubleMatrix1D);
        System.out.println("b = " + doubleMatrix1D2);
        System.out.println("c = " + doubleMatrix1D3);
        System.out.println("d = " + doubleMatrix1D4);
        System.out.println("done");
    }

    public static void doubleTest32() {
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 0.0}, {6.0, 2.0, 5.0}, {0.0, 7.0, 3.0}, {0.0, 0.0, 8.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        TridiagonalDoubleMatrix2D tridiagonalDoubleMatrix2D = new TridiagonalDoubleMatrix2D(dArrayArray);
        System.out.println("\n\n\n" + tridiagonalDoubleMatrix2D);
        System.out.println("\n" + new DenseDoubleMatrix2D(dArrayArray));
    }

    public static void doubleTest33() {
        double d = Double.NaN;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double[][] dArrayArray = new double[][]{{d3, d}};
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArrayArray);
        System.out.println("\n\n\n" + denseDoubleMatrix2D);
        System.out.println("\n" + denseDoubleMatrix2D.equals(d3));
    }

    public static void doubleTest34() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, 0.0, 0.0}, {0.0, 4.0, 2.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArrayArray);
        DoubleProperty.DEFAULT.generateNonSingular(denseDoubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D = DoubleAlgebra.DEFAULT.inverse(denseDoubleMatrix2D);
        System.out.println("\n\n\n" + denseDoubleMatrix2D);
        System.out.println("\n" + doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D.zMult(doubleMatrix2D, null);
        System.out.println(doubleMatrix2D2);
        if (!doubleMatrix2D2.equals(DoubleFactory2D.dense.identity(denseDoubleMatrix2D.rows()))) {
            throw new InternalError();
        }
    }

    public static void doubleTest35() {
    }

    public static void doubleTest36() {
        double[] dArray = new double[]{5.0, Double.NaN, 2.0, Double.NaN, 1.0};
        DoubleMatrix1D doubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        System.out.println("orig = " + doubleMatrix1D);
        doubleMatrix1D = doubleMatrix1D.viewSorted();
        doubleMatrix1D.toArray(dArray);
        System.out.println("sort = " + doubleMatrix1D);
        System.out.println("done\n");
    }

    public static void doubleTest4() {
        int n = 4;
        int n2 = 5;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        System.out.println(denseDoubleMatrix2D);
        ((DoubleMatrix2D)denseDoubleMatrix2D).assign(1.0);
        DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewPart(2, 0, 2, 3).assign(2.0);
        System.out.println("\n" + denseDoubleMatrix2D);
        System.out.println("\n" + doubleMatrix2D);
        doubleMatrix2D.assign(DoubleFunctions.mult(3.0));
        System.out.println("\n" + denseDoubleMatrix2D);
        System.out.println("\n" + doubleMatrix2D);
    }

    public static void doubleTest5() {
    }

    public static void doubleTest6() {
        int n = 4;
        int n2 = 5;
        DoubleMatrix2D doubleMatrix2D = Factory2D.ascending(n, n2);
        System.out.println("\n" + doubleMatrix2D);
        doubleMatrix2D.viewPart(2, 0, 2, 3).assign(2.0);
        System.out.println("\n" + doubleMatrix2D);
        int[] nArray = new int[]{0, 1, 3, 0, 1, 2};
        DoubleMatrix1D doubleMatrix1D = doubleMatrix2D.viewRow(0).viewSelection(nArray);
        System.out.println("view1=" + doubleMatrix1D);
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.viewPart(0, 3);
        System.out.println("view2=" + doubleMatrix1D2);
        doubleMatrix1D2.viewPart(0, 2).assign(-1.0);
        System.out.println("master replaced" + doubleMatrix2D);
        System.out.println("flip1 replaced" + doubleMatrix1D);
        System.out.println("flip2 replaced" + doubleMatrix1D2);
    }

    public static void doubleTest7() {
        int n = 4;
        int n2 = 5;
        DoubleMatrix2D doubleMatrix2D = Factory2D.ascending(n, n2);
        System.out.println("\n" + doubleMatrix2D);
        int[] nArray = new int[]{0, 1, 3, 0};
        int[] nArray2 = new int[]{0, 2};
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewSelection(nArray, nArray2);
        System.out.println("view1=" + doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewPart(0, 0, 2, 2);
        System.out.println("view2=" + doubleMatrix2D3);
        doubleMatrix2D3.assign(-1.0);
        System.out.println("master replaced" + doubleMatrix2D);
        System.out.println("flip1 replaced" + doubleMatrix2D2);
        System.out.println("flip2 replaced" + doubleMatrix2D3);
    }

    public static void doubleTest8() {
        int n = 2;
        int n2 = 3;
        DoubleMatrix2D doubleMatrix2D = Factory2D.ascending(n, n2);
        System.out.println("\n" + doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewDice();
        System.out.println("view1=" + doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewDice();
        System.out.println("view2=" + doubleMatrix2D3);
        doubleMatrix2D3.assign(-1.0);
        System.out.println("master replaced" + doubleMatrix2D);
        System.out.println("flip1 replaced" + doubleMatrix2D2);
        System.out.println("flip2 replaced" + doubleMatrix2D3);
    }

    public static void doubleTest9() {
        int n = 2;
        int n2 = 3;
        DoubleMatrix2D doubleMatrix2D = Factory2D.ascending(n, n2);
        System.out.println("\n" + doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewRowFlip();
        System.out.println("view1=" + doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewRowFlip();
        System.out.println("view2=" + doubleMatrix2D3);
        doubleMatrix2D3.assign(-1.0);
        System.out.println("master replaced" + doubleMatrix2D);
        System.out.println("flip1 replaced" + doubleMatrix2D2);
        System.out.println("flip2 replaced" + doubleMatrix2D3);
    }

    public static void doubleTestQR() {
        double[] dArray = new double[]{-6.221564, -9.002113, 2.678001, 6.483597, -7.934148};
        double[] dArray2 = new double[]{-7.291898, -7.346928, 0.520158, 5.012548, -8.223725};
        double[] dArray3 = new double[]{1.185925, -2.523077, 0.13538, 0.412556, -2.98028};
        double[] dArray4 = new double[]{13.561087, -15.20441, 16.496829, 16.47086, 0.822198};
        TestMatrix2D.solve(dArray3.length, dArray3, dArray4);
        TestMatrix2D.solve(dArray.length, dArray, dArray2);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        TestMatrix2D.doubleTest30(n, n2);
    }

    public static double[][] randomMatrix(int n, DoubleMersenneTwister doubleMersenneTwister) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = 5.0;
            }
        }
        return dArray;
    }

    public static void solve(int n, double[] dArray, double[] dArray2) {
    }

    public static void testLU() {
        double[][] dArrayArray = new double[][]{{-0.074683, 0.321248, -0.014656, 0.286586, 0.0}, {-0.344852, -0.16278, 0.173711, 6.4E-4, 0.0}, {-0.181924, -0.092926, 0.184153, 0.177966, 1.0}, {-0.166829, -0.10321, 0.582301, 0.142583, 0.0}, {0.0, -0.112952, -0.04932, -0.700157, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArrayArray);
        System.out.println("\nHplus=" + denseDoubleMatrix2D.viewDice().zMult(denseDoubleMatrix2D, null));
        DoubleMatrix2D doubleMatrix2D = DoubleAlgebra.DEFAULT.inverse(denseDoubleMatrix2D.viewDice().zMult(denseDoubleMatrix2D, null)).zMult(denseDoubleMatrix2D.viewDice(), null);
        doubleMatrix2D.assign(DoubleFunctions.round(1.0E-10));
        System.out.println("\nHplus=" + doubleMatrix2D);
    }

    public static void testMax() {
        double[] dArray = new double[]{8.9, 1.0};
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        DynamicDoubleBin1D dynamicDoubleBin1D = DoubleStatistic.bin(denseDoubleMatrix1D);
        double d = dynamicDoubleBin1D.max();
        System.out.println("max = " + d);
    }
}

