/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class DComplexFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 5196236412176785039L;
    public static final DComplexFactory2D dense = new DComplexFactory2D();
    public static final DComplexFactory2D sparse = new DComplexFactory2D();
    public static final DComplexFactory2D rowCompressed = new DComplexFactory2D();

    protected DComplexFactory2D() {
    }

    public DComplexMatrix2D appendColumns(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2) {
        if (dComplexMatrix2D2.rows() > dComplexMatrix2D.rows()) {
            dComplexMatrix2D2 = dComplexMatrix2D2.viewPart(0, 0, dComplexMatrix2D.rows(), dComplexMatrix2D2.columns());
        } else if (dComplexMatrix2D2.rows() < dComplexMatrix2D.rows()) {
            dComplexMatrix2D = dComplexMatrix2D.viewPart(0, 0, dComplexMatrix2D2.rows(), dComplexMatrix2D.columns());
        }
        int n = dComplexMatrix2D.columns();
        int n2 = dComplexMatrix2D2.columns();
        int n3 = dComplexMatrix2D.rows();
        DComplexMatrix2D dComplexMatrix2D3 = this.make(n3, n + n2);
        dComplexMatrix2D3.viewPart(0, 0, n3, n).assign(dComplexMatrix2D);
        dComplexMatrix2D3.viewPart(0, n, n3, n2).assign(dComplexMatrix2D2);
        return dComplexMatrix2D3;
    }

    public DComplexMatrix2D appendColumn(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D.size() > dComplexMatrix2D.rows()) {
            dComplexMatrix1D = dComplexMatrix1D.viewPart(0, dComplexMatrix2D.rows());
        } else if (dComplexMatrix1D.size() < dComplexMatrix2D.rows()) {
            dComplexMatrix2D = dComplexMatrix2D.viewPart(0, 0, dComplexMatrix1D.size(), dComplexMatrix2D.columns());
        }
        int n = dComplexMatrix2D.columns();
        int n2 = 1;
        int n3 = dComplexMatrix2D.rows();
        DComplexMatrix2D dComplexMatrix2D2 = this.make(n3, n + n2);
        dComplexMatrix2D2.viewPart(0, 0, n3, n).assign(dComplexMatrix2D);
        dComplexMatrix2D2.viewColumn(n).assign(dComplexMatrix1D);
        return dComplexMatrix2D2;
    }

    public DComplexMatrix2D appendRows(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2) {
        if (dComplexMatrix2D2.columns() > dComplexMatrix2D.columns()) {
            dComplexMatrix2D2 = dComplexMatrix2D2.viewPart(0, 0, dComplexMatrix2D2.rows(), dComplexMatrix2D.columns());
        } else if (dComplexMatrix2D2.columns() < dComplexMatrix2D.columns()) {
            dComplexMatrix2D = dComplexMatrix2D.viewPart(0, 0, dComplexMatrix2D.rows(), dComplexMatrix2D2.columns());
        }
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D2.rows();
        int n3 = dComplexMatrix2D.columns();
        DComplexMatrix2D dComplexMatrix2D3 = this.make(n + n2, n3);
        dComplexMatrix2D3.viewPart(0, 0, n, n3).assign(dComplexMatrix2D);
        dComplexMatrix2D3.viewPart(n, 0, n2, n3).assign(dComplexMatrix2D2);
        return dComplexMatrix2D3;
    }

    public DComplexMatrix2D appendRow(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D.size() > dComplexMatrix2D.columns()) {
            dComplexMatrix1D = dComplexMatrix1D.viewPart(0, dComplexMatrix2D.columns());
        } else if (dComplexMatrix1D.size() < dComplexMatrix2D.columns()) {
            dComplexMatrix2D = dComplexMatrix2D.viewPart(0, 0, dComplexMatrix2D.rows(), dComplexMatrix1D.size());
        }
        int n = dComplexMatrix2D.rows();
        int n2 = 1;
        int n3 = dComplexMatrix2D.columns();
        DComplexMatrix2D dComplexMatrix2D2 = this.make(n + n2, n3);
        dComplexMatrix2D2.viewPart(0, 0, n, n3).assign(dComplexMatrix2D);
        dComplexMatrix2D2.viewRow(n).assign(dComplexMatrix1D);
        return dComplexMatrix2D2;
    }

    protected static void checkRectangularShape(double[][] dArray) {
        int n = -1;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == null) continue;
            if (n == -1) {
                n = dArray[i].length;
            }
            if (dArray[i].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(DComplexMatrix2D[][] dComplexMatrix2DArray) {
        int n = -1;
        for (int i = 0; i < dComplexMatrix2DArray.length; ++i) {
            if (dComplexMatrix2DArray[i] == null) continue;
            if (n == -1) {
                n = dComplexMatrix2DArray[i].length;
            }
            if (dComplexMatrix2DArray[i].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public DComplexMatrix2D reshape(DComplexMatrix1D dComplexMatrix1D, int n, int n2) {
        if (dComplexMatrix1D.size() != n * n2) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        DComplexMatrix2D dComplexMatrix2D = this == sparse ? new SparseDComplexMatrix2D(n, n2) : new DenseDComplexMatrix2D(n, n2);
        for (int i = 0; i < n2; ++i) {
            dComplexMatrix2D.viewColumn(i).assign(dComplexMatrix1D.viewPart(i * n, n));
        }
        return dComplexMatrix2D;
    }

    public DComplexMatrix2D compose(DComplexMatrix2D[][] dComplexMatrix2DArray) {
        int n;
        int n2;
        int n3;
        DComplexFactory2D.checkRectangularShape(dComplexMatrix2DArray);
        int n4 = dComplexMatrix2DArray.length;
        int n5 = 0;
        if (dComplexMatrix2DArray.length > 0) {
            n5 = dComplexMatrix2DArray[0].length;
        }
        DComplexMatrix2D dComplexMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return dComplexMatrix2D;
        }
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                DComplexMatrix2D dComplexMatrix2D2 = dComplexMatrix2DArray[n2][i];
                if (dComplexMatrix2D2 == null) continue;
                int n6 = dComplexMatrix2D2.columns();
                if (n3 > 0 && n6 > 0 && n6 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n6);
            }
            nArray[i] = n3;
        }
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            for (int i = 0; i < n5; ++i) {
                DComplexMatrix2D dComplexMatrix2D3 = dComplexMatrix2DArray[n3][i];
                if (dComplexMatrix2D3 == null) continue;
                n = dComplexMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        for (int i = 0; i < n5; ++i) {
            n2 += nArray[i];
        }
        DComplexMatrix2D dComplexMatrix2D4 = this.make(n3, n2);
        int n7 = 0;
        for (n = 0; n < n4; ++n) {
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                DComplexMatrix2D dComplexMatrix2D5 = dComplexMatrix2DArray[n][i];
                if (dComplexMatrix2D5 != null) {
                    dComplexMatrix2D4.viewPart(n7, n8, dComplexMatrix2D5.rows(), dComplexMatrix2D5.columns()).assign(dComplexMatrix2D5);
                }
                n8 += nArray[i];
            }
            n7 += nArray2[n];
        }
        return dComplexMatrix2D4;
    }

    public DComplexMatrix2D composeDiagonal(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2) {
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D.columns();
        int n3 = dComplexMatrix2D2.rows();
        int n4 = dComplexMatrix2D2.columns();
        DComplexMatrix2D dComplexMatrix2D3 = this.make(n + n3, n2 + n4);
        dComplexMatrix2D3.viewPart(0, 0, n, n2).assign(dComplexMatrix2D);
        dComplexMatrix2D3.viewPart(n, n2, n3, n4).assign(dComplexMatrix2D2);
        return dComplexMatrix2D3;
    }

    public DComplexMatrix2D composeDiagonal(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, DComplexMatrix2D dComplexMatrix2D3) {
        DComplexMatrix2D dComplexMatrix2D4 = this.make(dComplexMatrix2D.rows() + dComplexMatrix2D2.rows() + dComplexMatrix2D3.rows(), dComplexMatrix2D.columns() + dComplexMatrix2D2.columns() + dComplexMatrix2D3.columns());
        dComplexMatrix2D4.viewPart(0, 0, dComplexMatrix2D.rows(), dComplexMatrix2D.columns()).assign(dComplexMatrix2D);
        dComplexMatrix2D4.viewPart(dComplexMatrix2D.rows(), dComplexMatrix2D.columns(), dComplexMatrix2D2.rows(), dComplexMatrix2D2.columns()).assign(dComplexMatrix2D2);
        dComplexMatrix2D4.viewPart(dComplexMatrix2D.rows() + dComplexMatrix2D2.rows(), dComplexMatrix2D.columns() + dComplexMatrix2D2.columns(), dComplexMatrix2D3.rows(), dComplexMatrix2D3.columns()).assign(dComplexMatrix2D3);
        return dComplexMatrix2D4;
    }

    public DComplexMatrix2D composeBidiagonal(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2) {
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D.columns();
        int n3 = dComplexMatrix2D2.rows();
        int n4 = dComplexMatrix2D2.columns();
        DComplexMatrix2D dComplexMatrix2D3 = this.make(n + n3 - 1, n2 + n4);
        dComplexMatrix2D3.viewPart(0, 0, n, n2).assign(dComplexMatrix2D);
        dComplexMatrix2D3.viewPart(n - 1, n2, n3, n4).assign(dComplexMatrix2D2);
        return dComplexMatrix2D3;
    }

    public void decompose(DComplexMatrix2D[][] dComplexMatrix2DArray, DComplexMatrix2D dComplexMatrix2D) {
        int n;
        int n2;
        int n3;
        int n4;
        DComplexFactory2D.checkRectangularShape(dComplexMatrix2DArray);
        int n5 = dComplexMatrix2DArray.length;
        int n6 = 0;
        if (dComplexMatrix2DArray.length > 0) {
            n6 = dComplexMatrix2DArray[0].length;
        }
        if (n5 == 0 || n6 == 0) {
            return;
        }
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                DComplexMatrix2D dComplexMatrix2D2 = dComplexMatrix2DArray[n3][i];
                if (dComplexMatrix2D2 == null) continue;
                int n7 = dComplexMatrix2D2.columns();
                if (n4 > 0 && n7 > 0 && n7 != n4) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n4 = Math.max(n4, n7);
            }
            nArray[i] = n4;
        }
        int[] nArray2 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 0;
            for (int i = 0; i < n6; ++i) {
                DComplexMatrix2D dComplexMatrix2D3 = dComplexMatrix2DArray[n4][i];
                if (dComplexMatrix2D3 == null) continue;
                n2 = dComplexMatrix2D3.rows();
                if (n3 > 0 && n2 > 0 && n2 != n3) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n3 = Math.max(n3, n2);
            }
            nArray2[n4] = n3;
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n4 += nArray2[n3];
        }
        n3 = 0;
        for (n = 0; n < n6; ++n) {
            n3 += nArray[n];
        }
        if (dComplexMatrix2D.rows() < n4 || dComplexMatrix2D.columns() < n3) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n = 0;
        for (int i = 0; i < n5; ++i) {
            n2 = 0;
            for (int j = 0; j < n6; ++j) {
                DComplexMatrix2D dComplexMatrix2D4 = dComplexMatrix2DArray[i][j];
                if (dComplexMatrix2D4 != null) {
                    dComplexMatrix2D4.assign(dComplexMatrix2D.viewPart(n, n2, dComplexMatrix2D4.rows(), dComplexMatrix2D4.columns()));
                }
                n2 += nArray[j];
            }
            n += nArray2[i];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        DComplexMatrix2D[][] dComplexMatrix2DArray = new DComplexMatrix2D[][]{{null, this.make(2, 2, new double[]{1.0, 2.0}), null}, {this.make(4, 4, new double[]{3.0, 4.0}), null, this.make(4, 3, new double[]{5.0, 6.0})}, {null, this.make(2, 2, new double[]{7.0, 8.0}), null}};
        System.out.println("\n" + this.compose(dComplexMatrix2DArray));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object var9_1 = null;
        DComplexMatrix2D dComplexMatrix2D = this.make(2, 2, new double[]{1.0, 2.0});
        DComplexMatrix2D dComplexMatrix2D2 = this.make(4, 4, new double[]{3.0, 4.0});
        DComplexMatrix2D dComplexMatrix2D3 = this.make(4, 3, new double[]{5.0, 6.0});
        DComplexMatrix2D dComplexMatrix2D4 = this.make(2, 2, new double[]{7.0, 8.0});
        DComplexMatrix2D[][] dComplexMatrix2DArray = new DComplexMatrix2D[][]{{var9_1, dComplexMatrix2D, var9_1}, {dComplexMatrix2D2, var9_1, dComplexMatrix2D3}, {var9_1, dComplexMatrix2D4, var9_1}};
        DComplexMatrix2D dComplexMatrix2D5 = this.compose(dComplexMatrix2DArray);
        System.out.println("\n" + dComplexMatrix2D5);
        dComplexMatrix2D.assign(9.0, 9.0);
        dComplexMatrix2D2.assign(9.0, 9.0);
        dComplexMatrix2D3.assign(9.0, 9.0);
        dComplexMatrix2D4.assign(9.0, 9.0);
        this.decompose(dComplexMatrix2DArray, dComplexMatrix2D5);
        System.out.println(dComplexMatrix2D);
        System.out.println(dComplexMatrix2D2);
        System.out.println(dComplexMatrix2D3);
        System.out.println(dComplexMatrix2D4);
    }

    public DComplexMatrix2D diagonal(DComplexMatrix1D dComplexMatrix1D) {
        int n = dComplexMatrix1D.size();
        DComplexMatrix2D dComplexMatrix2D = this.make(n, n);
        for (int i = 0; i < n; ++i) {
            dComplexMatrix2D.setQuick(i, i, dComplexMatrix1D.getQuick(i));
        }
        return dComplexMatrix2D;
    }

    public DComplexMatrix1D diagonal(DComplexMatrix2D dComplexMatrix2D) {
        int n = Math.min(dComplexMatrix2D.rows(), dComplexMatrix2D.columns());
        DComplexMatrix1D dComplexMatrix1D = this.make1D(n);
        for (int i = 0; i < n; ++i) {
            dComplexMatrix1D.setQuick(i, dComplexMatrix2D.getQuick(i, i));
        }
        return dComplexMatrix1D;
    }

    public DComplexMatrix2D identity(int n) {
        DComplexMatrix2D dComplexMatrix2D = this.make(n, n);
        double[] dArray = new double[]{1.0, 0.0};
        int n2 = n;
        while (--n2 >= 0) {
            dComplexMatrix2D.setQuick(n2, n2, dArray);
        }
        return dComplexMatrix2D;
    }

    public DComplexMatrix2D make(double[][] dArray) {
        if (this == sparse) {
            return new SparseDComplexMatrix2D(dArray);
        }
        return new DenseDComplexMatrix2D(dArray);
    }

    public DComplexMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseDComplexMatrix2D(n, n2);
        }
        if (this == rowCompressed) {
            throw new IllegalArgumentException("RCComplexMatrix2D is not supported yet");
        }
        return new DenseDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix2D make(int n, int n2, double[] dArray) {
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(dArray);
    }

    protected DComplexMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public DComplexMatrix2D random(int n, int n2) {
        return this.make(n, n2).assign(DComplexFunctions.random());
    }

    public DComplexMatrix2D repeat(DComplexMatrix2D dComplexMatrix2D, int n, int n2) {
        int n3 = dComplexMatrix2D.rows();
        int n4 = dComplexMatrix2D.columns();
        DComplexMatrix2D dComplexMatrix2D2 = this.make(n3 * n, n4 * n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dComplexMatrix2D2.viewPart(n3 * i, n4 * j, n3, n4).assign(dComplexMatrix2D);
            }
        }
        return dComplexMatrix2D2;
    }

    public DComplexMatrix2D sample(int n, int n2, double[] dArray, double d) {
        DComplexMatrix2D dComplexMatrix2D = this.make(n, n2);
        this.sample(dComplexMatrix2D, dArray, d);
        return dComplexMatrix2D;
    }

    public DComplexMatrix2D sample(DComplexMatrix2D dComplexMatrix2D, double[] dArray, double d) {
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D.columns();
        double d2 = 1.0E-9;
        if (d < 0.0 - d2 || d > 1.0 + d2) {
            throw new IllegalArgumentException();
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        dComplexMatrix2D.assign(0.0, 0.0);
        int n3 = n * n2;
        int n4 = (int)Math.round((double)n3 * d);
        if (n4 == 0) {
            return dComplexMatrix2D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n4, n3, new DoubleMersenneTwister());
        for (int i = 0; i < n3; ++i) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            int n5 = i / n2;
            int n6 = i % n2;
            dComplexMatrix2D.set(n5, n6, dArray);
        }
        return dComplexMatrix2D;
    }
}

