/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DComplexMatrix1D
extends AbstractMatrix1D {
    protected DComplexMatrix1D() {
    }

    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        int n = this.size();
        if (n == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        double[] dArray2 = dComplexDComplexFunction.apply(this.getQuick(0));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            double[][] dArray3 = new double[n2][2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = dComplexDComplexFunction.apply(DComplexMatrix1D.this.getQuick(n4));
                        for (int i = n4 + 1; i < n5; ++i) {
                            dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(DComplexMatrix1D.this.getQuick(i)));
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            for (int i = 1; i < n; ++i) {
                dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(this.getQuick(i)));
            }
        }
        return dArray2;
    }

    public double[] aggregate(final DComplexMatrix1D dComplexMatrix1D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        this.checkSize(dComplexMatrix1D);
        int n = this.size();
        if (n == 0) {
            double[] dArray = new double[]{Double.NaN, Double.NaN};
            return dArray;
        }
        double[] dArray = dComplexDComplexDComplexFunction2.apply(this.getQuick(0), dComplexMatrix1D.getQuick(0));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            double[][] dArray2 = new double[n2][2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = dComplexDComplexDComplexFunction2.apply(DComplexMatrix1D.this.getQuick(n4), dComplexMatrix1D.getQuick(n4));
                        for (int i = n4 + 1; i < n5; ++i) {
                            dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(DComplexMatrix1D.this.getQuick(i), dComplexMatrix1D.getQuick(i)));
                        }
                        return dArray;
                    }
                });
            }
            dArray = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            for (int i = 1; i < n; ++i) {
                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(this.getQuick(i), dComplexMatrix1D.getQuick(i)));
            }
        }
        return dArray;
    }

    public DComplexMatrix1D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = this.size();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DComplexMatrix1D.this.setQuick(i, dComplexDComplexFunction.apply(DComplexMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, dComplexDComplexFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    double[] elem;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.elem = DComplexMatrix1D.this.getQuick(i);
                            if (!dComplexProcedure.apply(this.elem)) continue;
                            DComplexMatrix1D.this.setQuick(i, dComplexDComplexFunction.apply(this.elem));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] dArray = this.getQuick(i);
                if (!dComplexProcedure.apply(dArray)) continue;
                this.setQuick(i, dComplexDComplexFunction.apply(dArray));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    double[] elem;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.elem = DComplexMatrix1D.this.getQuick(i);
                            if (!dComplexProcedure.apply(this.elem)) continue;
                            DComplexMatrix1D.this.setQuick(i, dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] dArray2 = this.getQuick(i);
                if (!dComplexProcedure.apply(dArray2)) continue;
                this.setQuick(i, dArray);
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexRealFunction dComplexRealFunction) {
        int n = this.size();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DComplexMatrix1D.this.setQuick(i, dComplexRealFunction.apply(DComplexMatrix1D.this.getQuick(i)), 0.0);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, dComplexRealFunction.apply(this.getQuick(i)), 0.0);
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D == this) {
            return this;
        }
        this.checkSize(dComplexMatrix1D);
        final DComplexMatrix1D dComplexMatrix1D2 = this.haveSharedCells(dComplexMatrix1D) ? dComplexMatrix1D.copy() : dComplexMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DComplexMatrix1D.this.setQuick(i, dComplexMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, dComplexMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexMatrix1D dComplexMatrix1D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        int n = this.size();
        this.checkSize(dComplexMatrix1D);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DComplexMatrix1D.this.setQuick(i, dComplexDComplexDComplexFunction.apply(DComplexMatrix1D.this.getQuick(i), dComplexMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, dComplexDComplexDComplexFunction.apply(this.getQuick(i), dComplexMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final double d, final double d2) {
        int n = this.size();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DComplexMatrix1D.this.setQuick(i, d, d2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, d, d2);
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final double[] dArray) {
        int n = this.size();
        if (dArray.length != 2 * n) {
            throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + this.size());
        }
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DComplexMatrix1D.this.setQuick(i, dArray[2 * i], dArray[2 * i + 1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, dArray[2 * i], dArray[2 * i + 1]);
            }
        }
        return this;
    }

    public DComplexMatrix1D assignImaginary(final DoubleMatrix1D doubleMatrix1D) {
        this.checkSize(doubleMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double d = DComplexMatrix1D.this.getQuick(i)[0];
                            double d2 = doubleMatrix1D.getQuick(i);
                            DComplexMatrix1D.this.setQuick(i, d, d2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double d = this.getQuick(i)[0];
                double d2 = doubleMatrix1D.getQuick(i);
                this.setQuick(i, d, d2);
            }
        }
        return this;
    }

    public DComplexMatrix1D assignReal(final DoubleMatrix1D doubleMatrix1D) {
        this.checkSize(doubleMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double d = doubleMatrix1D.getQuick(i);
                            double d2 = DComplexMatrix1D.this.getQuick(i)[1];
                            DComplexMatrix1D.this.setQuick(i, d, d2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double d = doubleMatrix1D.getQuick(i);
                double d2 = this.getQuick(i)[1];
                this.setQuick(i, d, d2);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = this.size();
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = n / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? n : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        double[] dArray = new double[2];
                        for (int i = n6; i < n7; ++i) {
                            dArray = DComplexMatrix1D.this.getQuick(i);
                            if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n2 = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n2 += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < n; ++i) {
                dArray = this.getQuick(i);
                if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                ++n2;
            }
        }
        return n2;
    }

    public DComplexMatrix1D copy() {
        DComplexMatrix1D dComplexMatrix1D = this.like();
        dComplexMatrix1D.assign(this);
        return dComplexMatrix1D;
    }

    public boolean equals(double[] dArray) {
        return DoubleProperty.DEFAULT.equals(this, dArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DComplexMatrix1D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DComplexMatrix1D)object);
    }

    public double[] get(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    public abstract Object elements();

    public abstract DoubleMatrix1D getImaginaryPart();

    public void getNonZeros(IntArrayList intArrayList, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        arrayList.clear();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.getQuick(i);
            if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
            intArrayList.add(i);
            arrayList.add(dArray);
        }
    }

    public abstract double[] getQuick(int var1);

    public abstract DoubleMatrix1D getRealPart();

    public DComplexMatrix1D like() {
        int n = this.size();
        return this.like(n);
    }

    public abstract DComplexMatrix1D like(int var1);

    public abstract DComplexMatrix2D like2D(int var1, int var2);

    public abstract DComplexMatrix2D reshape(int var1, int var2);

    public abstract DComplexMatrix3D reshape(int var1, int var2, int var3);

    public void set(int n, double d, double d2) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            this.checkIndex(n);
        }
        this.setQuick(n, d, d2);
    }

    public void set(int n, double[] dArray) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            this.checkIndex(n);
        }
        this.setQuick(n, dArray);
    }

    public abstract void setQuick(int var1, double var2, double var4);

    public abstract void setQuick(int var1, double[] var2);

    public void swap(final DComplexMatrix1D dComplexMatrix1D) {
        int n = this.size();
        this.checkSize(dComplexMatrix1D);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[] dArray = DComplexMatrix1D.this.getQuick(i);
                            DComplexMatrix1D.this.setQuick(i, dComplexMatrix1D.getQuick(i));
                            dComplexMatrix1D.setQuick(i, dArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                double[] dArray = this.getQuick(i);
                this.setQuick(i, dComplexMatrix1D.getQuick(i));
                dComplexMatrix1D.setQuick(i, dArray);
            }
        }
    }

    public double[] toArray() {
        int n = this.size();
        double[] dArray = new double[2 * n];
        this.toArray(dArray);
        return dArray;
    }

    public void toArray(final double[] dArray) {
        int n = this.size();
        if (dArray.length < 2 * n) {
            throw new IllegalArgumentException("values too small");
        }
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            dArray2 = DComplexMatrix1D.this.getQuick(i);
                            dArray[2 * i] = dArray2[0];
                            dArray[2 * i + 1] = dArray2[1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            for (int i = 0; i < n; ++i) {
                dArray2 = this.getQuick(i);
                dArray[2 * i] = dArray2[0];
                dArray[2 * i + 1] = dArray2[1];
            }
        }
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format("ComplexMatrix1D: %d elements\n\n", this.size()));
        double[] dArray = new double[2];
        for (int i = 0; i < this.size(); ++i) {
            dArray = this.getQuick(i);
            if (dArray[1] == 0.0) {
                stringBuffer.append(String.format(string + "\n", dArray[0]));
                continue;
            }
            if (dArray[0] == 0.0) {
                stringBuffer.append(String.format(string + "i\n", dArray[1]));
                continue;
            }
            if (dArray[1] < 0.0) {
                stringBuffer.append(String.format(string + " - " + string + "i\n", dArray[0], -dArray[1]));
                continue;
            }
            stringBuffer.append(String.format(string + " + " + string + "i\n", dArray[0], dArray[1]));
        }
        return stringBuffer.toString();
    }

    public DComplexMatrix1D viewFlip() {
        return (DComplexMatrix1D)this.view().vFlip();
    }

    public DComplexMatrix1D viewPart(int n, int n2) {
        return (DComplexMatrix1D)this.view().vPart(n, n2);
    }

    public DComplexMatrix1D viewSelection(DComplexProcedure dComplexProcedure) {
        int n = this.size();
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < n; ++i) {
            if (!dComplexProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    public DComplexMatrix1D viewSelection(int[] nArray) {
        int n = this.size();
        if (nArray == null) {
            nArray = new int[n];
            int n2 = n - 1;
            while (--n2 >= 0) {
                nArray[n2] = n2;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)this.index(nArray[i]);
        }
        return this.viewSelectionLike(nArray2);
    }

    public DComplexMatrix1D viewStrides(int n) {
        return (DComplexMatrix1D)this.view().vStrides(n);
    }

    public double[] zDotProduct(DComplexMatrix1D dComplexMatrix1D) {
        int n = this.size();
        return this.zDotProduct(dComplexMatrix1D, 0, n);
    }

    public double[] zDotProduct(final DComplexMatrix1D dComplexMatrix1D, final int n, int n2) {
        int n3 = this.size();
        if (n < 0 || n2 <= 0) {
            return new double[]{0.0, 0.0};
        }
        int n4 = n + n2;
        if (n3 < n4) {
            n4 = n3;
        }
        if (dComplexMatrix1D.size < n4) {
            n4 = dComplexMatrix1D.size;
        }
        n2 = n4 - n;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        double[] dArray = new double[2];
        if (n5 > 1 && n3 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n6;
            Future[] futureArray = new Future[n5];
            double[][] dArray2 = new double[n5][2];
            int n7 = n2 / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? n2 : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = new double[2];
                        for (int i = n8; i < n9; ++i) {
                            int n2 = i + n;
                            double[] dArray2 = dComplexMatrix1D.getQuick(n2);
                            dArray2[1] = -dArray2[1];
                            dArray = DComplex.plus(dArray, DComplex.mult(DComplexMatrix1D.this.getQuick(n2), dArray2));
                        }
                        return dArray;
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    dArray2[n6] = (double[])futureArray[n6].get();
                }
                dArray = dArray2[0];
                for (n6 = 1; n6 < n5; ++n6) {
                    dArray = DComplex.plus(dArray, dArray2[n6]);
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n10 = i + n;
                double[] dArray3 = dComplexMatrix1D.getQuick(n10);
                dArray3[1] = -dArray3[1];
                dArray = DComplex.plus(dArray, DComplex.mult(this.getQuick(n10), dArray3));
            }
        }
        return dArray;
    }

    public double[] zDotProduct(DComplexMatrix1D dComplexMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        int n5 = this.size();
        if (n < 0 || n2 <= 0) {
            return new double[]{0.0, 0.0};
        }
        int n6 = n + n2;
        if (n5 < n6) {
            n6 = n5;
        }
        if (dComplexMatrix1D.size < n6) {
            n6 = dComplexMatrix1D.size;
        }
        if ((n2 = n6 - n) <= 0) {
            return new double[]{0.0, 0.0};
        }
        IntArrayList intArrayList2 = intArrayList.copy();
        intArrayList2.trimToSize();
        intArrayList2.quickSort();
        int[] nArray = intArrayList2.elements();
        int n7 = intArrayList2.size();
        for (n4 = 0; n4 < n7 && nArray[n4] < n; ++n4) {
        }
        double[] dArray = new double[2];
        while (--n2 >= 0 && n4 < n7 && (n3 = nArray[n4]) < n6) {
            double[] dArray2 = dComplexMatrix1D.getQuick(n3);
            dArray2[1] = -dArray2[1];
            dArray = DComplex.plus(dArray, DComplex.mult(this.getQuick(n3), dArray2));
            ++n4;
        }
        return dArray;
    }

    public double[] zSum() {
        if (this.size() == 0) {
            return new double[]{0.0, 0.0};
        }
        return this.aggregate(DComplexFunctions.plus, DComplexFunctions.identity);
    }

    protected int cardinality(int n) {
        int n2 = this.size();
        int n3 = 0;
        int n4 = 0;
        double[] dArray = new double[2];
        while (n4++ < n2 && n3 < n) {
            dArray = this.getQuick(n4);
            if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
            ++n3;
        }
        return n3;
    }

    protected DComplexMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D == null) {
            return false;
        }
        if (this == dComplexMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(dComplexMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix1D dComplexMatrix1D) {
        return false;
    }

    protected DComplexMatrix1D view() {
        return (DComplexMatrix1D)this.clone();
    }

    protected abstract DComplexMatrix1D viewSelectionLike(int[] var1);

    protected double[] zDotProduct(DComplexMatrix1D dComplexMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(dComplexMatrix1D, 0, this.size(), intArrayList);
    }
}

