/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1DProcedure;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DComplexMatrix2D
extends AbstractMatrix2D {
    protected DComplexMatrix2D() {
    }

    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        if (this.size() == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        double[] dArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            double[][] dArray3 = new double[n][2];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = dComplexDComplexFunction.apply(DComplexMatrix2D.this.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < DComplexMatrix2D.this.columns; ++j) {
                                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(DComplexMatrix2D.this.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexFunction.apply(this.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(this.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return dArray2;
    }

    public double[] aggregate(final DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        this.checkShape(dComplexMatrix2D);
        double[] dArray = new double[2];
        if (this.size() == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        double[] dArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            double[][] dArray3 = new double[n][2];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = dComplexDComplexDComplexFunction2.apply(DComplexMatrix2D.this.getQuick(n3, 0), dComplexMatrix2D.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < DComplexMatrix2D.this.columns; ++j) {
                                dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(DComplexMatrix2D.this.getQuick(i, j), dComplexMatrix2D.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexDComplexFunction2.apply(this.getQuick(0, 0), dComplexMatrix2D.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexDComplexFunction2.apply(this.getQuick(i, j), dComplexMatrix2D.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return dArray2;
    }

    public DComplexMatrix2D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, dComplexDComplexFunction.apply(DComplexMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dComplexDComplexFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                double[] dArray = DComplexMatrix2D.this.getQuick(i, j);
                                if (!dComplexProcedure.apply(dArray)) continue;
                                DComplexMatrix2D.this.setQuick(i, j, dComplexDComplexFunction.apply(dArray));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double[] dArray = this.getQuick(i, j);
                    if (!dComplexProcedure.apply(dArray)) continue;
                    this.setQuick(i, j, dComplexDComplexFunction.apply(dArray));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                double[] dArray2 = DComplexMatrix2D.this.getQuick(i, j);
                                if (!dComplexProcedure.apply(dArray2)) continue;
                                DComplexMatrix2D.this.setQuick(i, j, dArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double[] dArray2 = this.getQuick(i, j);
                    if (!dComplexProcedure.apply(dArray2)) continue;
                    this.setQuick(i, j, dArray);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexRealFunction dComplexRealFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                double d = dComplexRealFunction.apply(DComplexMatrix2D.this.getQuick(i, j));
                                DComplexMatrix2D.this.setQuick(i, j, d, 0.0);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double d = dComplexRealFunction.apply(this.getQuick(i, j));
                    this.setQuick(i, j, d, 0.0);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(dComplexMatrix2D);
        final DComplexMatrix2D dComplexMatrix2D2 = this.haveSharedCells(dComplexMatrix2D) ? dComplexMatrix2D.copy() : dComplexMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, dComplexMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dComplexMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexMatrix2D dComplexMatrix2D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        this.checkShape(dComplexMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, dComplexDComplexDComplexFunction.apply(DComplexMatrix2D.this.getQuick(i, j), dComplexMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dComplexDComplexDComplexFunction.apply(this.getQuick(i, j), dComplexMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final double d, final double d2) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, d, d2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, d, d2);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final double[] dArray) {
        if (dArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * 2 * this.columns;
                final int n5 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, dArray[n], dArray[n + 1]);
                                n += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dArray[n6], dArray[n6 + 1]);
                    n6 += 2;
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final double[][] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray2 = dArray[i];
                            if (dArray2.length != 2 * DComplexMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + 2 * DComplexMatrix2D.this.columns());
                            }
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, dArray2[2 * j], dArray2[2 * j + 1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                double[] dArray2 = dArray[i];
                if (dArray2.length != 2 * this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + 2 * this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dArray2[2 * j], dArray2[2 * j + 1]);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * 2 * this.columns;
                final int n5 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                DComplexMatrix2D.this.setQuick(i, j, fArray[n], fArray[n + 1]);
                                n += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fArray[n6], fArray[n6 + 1]);
                    n6 += 2;
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assignImaginary(final DoubleMatrix2D doubleMatrix2D) {
        this.checkShape(doubleMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                double d = DComplexMatrix2D.this.getQuick(i, j)[0];
                                double d2 = doubleMatrix2D.getQuick(i, j);
                                DComplexMatrix2D.this.setQuick(i, j, d, d2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double d = this.getQuick(i, j)[0];
                    double d2 = doubleMatrix2D.getQuick(i, j);
                    this.setQuick(i, j, d, d2);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assignReal(final DoubleMatrix2D doubleMatrix2D) {
        this.checkShape(doubleMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                double d = doubleMatrix2D.getQuick(i, j);
                                double d2 = DComplexMatrix2D.this.getQuick(i, j)[1];
                                DComplexMatrix2D.this.setQuick(i, j, d, d2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double d = doubleMatrix2D.getQuick(i, j);
                    double d2 = this.getQuick(i, j)[1];
                    this.setQuick(i, j, d, d2);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        double[] dArray = new double[2];
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                dArray = DComplexMatrix2D.this.getQuick(i, j);
                                if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    dArray = this.getQuick(i, j);
                    if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public DComplexMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double[] dArray) {
        return DoubleProperty.DEFAULT.equals(this, dArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DComplexMatrix2D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DComplexMatrix2D)object);
    }

    public DComplexMatrix2D forEachNonZero(final IntIntDComplexFunction intIntDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                double[] dArray = DComplexMatrix2D.this.getQuick(i, j);
                                if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                                double[] dArray2 = intIntDComplexFunction.apply(i, j, dArray);
                                DComplexMatrix2D.this.setQuick(i, j, dArray2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double[] dArray = this.getQuick(i, j);
                    if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                    double[] dArray2 = intIntDComplexFunction.apply(i, j, dArray);
                    this.setQuick(i, j, dArray2);
                }
            }
        }
        return this;
    }

    public double[] get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    public DComplexMatrix2D getConjugateTranspose() {
        final DComplexMatrix2D dComplexMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.rows; ++j) {
                                dArray = dComplexMatrix2D.getQuick(i, j);
                                dArray[1] = -dArray[1];
                                dComplexMatrix2D.setQuick(i, j, dArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    dArray = dComplexMatrix2D.getQuick(i, j);
                    dArray[1] = -dArray[1];
                    dComplexMatrix2D.setQuick(i, j, dArray);
                }
            }
        }
        return dComplexMatrix2D;
    }

    public abstract Object elements();

    public abstract DoubleMatrix2D getImaginaryPart();

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.getQuick(i, j);
                if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                arrayList.add(dArray);
            }
        }
    }

    public abstract double[] getQuick(int var1, int var2);

    public abstract DoubleMatrix2D getRealPart();

    public DComplexMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DComplexMatrix2D like(int var1, int var2);

    public abstract DComplexMatrix1D like1D(int var1);

    public void set(int n, int n2, double[] dArray) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, dArray);
    }

    public abstract void setQuick(int var1, int var2, double var3, double var5);

    public abstract void setQuick(int var1, int var2, double[] var3);

    public double[][] toArray() {
        final double[][] dArray = new double[this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2];
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                dArray2 = DComplexMatrix2D.this.getQuick(i, j);
                                dArray[i][2 * j] = dArray2[0];
                                dArray[i][2 * j + 1] = dArray2[1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    dArray2 = this.getQuick(i, j);
                    dArray[i][2 * j] = dArray2[0];
                    dArray[i][2 * j + 1] = dArray2[1];
                }
            }
        }
        return dArray;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format("ComplexMatrix2D: %d rows, %d columns\n\n", this.rows, this.columns));
        double[] dArray = new double[2];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                dArray = this.getQuick(i, j);
                if (dArray[1] == 0.0) {
                    stringBuffer.append(String.format(string + "\t", dArray[0]));
                    continue;
                }
                if (dArray[0] == 0.0) {
                    stringBuffer.append(String.format(string + "i\t", dArray[1]));
                    continue;
                }
                if (dArray[1] < 0.0) {
                    stringBuffer.append(String.format(string + " - " + string + "i\t", dArray[0], -dArray[1]));
                    continue;
                }
                stringBuffer.append(String.format(string + " + " + string + "i\t", dArray[0], dArray[1]));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public abstract DComplexMatrix1D vectorize();

    public DComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public DComplexMatrix2D viewColumnFlip() {
        return (DComplexMatrix2D)this.view().vColumnFlip();
    }

    public DComplexMatrix2D viewDice() {
        return (DComplexMatrix2D)this.view().vDice();
    }

    public DComplexMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (DComplexMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public DComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public DComplexMatrix2D viewRowFlip() {
        return (DComplexMatrix2D)this.view().vRowFlip();
    }

    public DComplexMatrix2D viewSelection(DComplexMatrix1DProcedure dComplexMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!dComplexMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    public DComplexMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray2[n2] = n2;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = this._rowOffset(this._rowRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray2[n]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public DComplexMatrix2D viewStrides(int n, int n2) {
        return (DComplexMatrix2D)this.view().vStrides(n, n2);
    }

    public DComplexMatrix1D zMult(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2) {
        double[] dArray;
        double[] dArray2 = new double[]{1.0, 0.0};
        if (dComplexMatrix1D2 == null) {
            double[] dArray3 = new double[2];
            dArray3[0] = 1.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        } else {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        }
        return this.zMult(dComplexMatrix1D, dComplexMatrix1D2, dArray2, dArray, false);
    }

    public DComplexMatrix1D zMult(final DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2, final double[] dArray, final double[] dArray2, boolean bl) {
        if (bl) {
            return this.getConjugateTranspose().zMult(dComplexMatrix1D, dComplexMatrix1D2, dArray, dArray2, false);
        }
        final DComplexMatrix1D dComplexMatrix1D3 = dComplexMatrix1D2 == null ? new DenseDComplexMatrix1D(this.rows) : dComplexMatrix1D2;
        if (this.columns != dComplexMatrix1D.size() || this.rows > dComplexMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + dComplexMatrix1D.toStringShort() + ", " + dComplexMatrix1D3.toStringShort());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    double[] s = new double[2];

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.s[0] = 0.0;
                            this.s[1] = 0.0;
                            for (int j = 0; j < DComplexMatrix2D.this.columns; ++j) {
                                this.s = DComplex.plus(this.s, DComplex.mult(DComplexMatrix2D.this.getQuick(i, j), dComplexMatrix1D.getQuick(j)));
                            }
                            dComplexMatrix1D3.setQuick(i, DComplex.plus(DComplex.mult(this.s, dArray), DComplex.mult(dComplexMatrix1D3.getQuick(i), dArray2)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray3 = new double[2];
            for (int i = 0; i < this.rows; ++i) {
                dArray3[0] = 0.0;
                dArray3[1] = 0.0;
                for (int j = 0; j < this.columns; ++j) {
                    dArray3 = DComplex.plus(dArray3, DComplex.mult(this.getQuick(i, j), dComplexMatrix1D.getQuick(j)));
                }
                dComplexMatrix1D3.setQuick(i, DComplex.plus(DComplex.mult(dArray3, dArray), DComplex.mult(dComplexMatrix1D3.getQuick(i), dArray2)));
            }
        }
        dComplexMatrix1D2 = dComplexMatrix1D3;
        return dComplexMatrix1D2;
    }

    public DComplexMatrix2D zMult(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2) {
        double[] dArray;
        double[] dArray2 = new double[]{1.0, 0.0};
        if (dComplexMatrix2D2 == null) {
            double[] dArray3 = new double[2];
            dArray3[0] = 1.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        } else {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        }
        return this.zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray2, dArray, false, false);
    }

    public DComplexMatrix2D zMult(final DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, final double[] dArray, final double[] dArray2, boolean bl, boolean bl2) {
        if (bl) {
            return this.getConjugateTranspose().zMult(dComplexMatrix2D, dComplexMatrix2D2, dArray, dArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(dComplexMatrix2D.getConjugateTranspose(), dComplexMatrix2D2, dArray, dArray2, bl, false);
        }
        final int n = this.rows;
        final int n2 = this.columns;
        int n3 = dComplexMatrix2D.columns;
        final DComplexMatrix2D dComplexMatrix2D3 = dComplexMatrix2D2 == null ? new DenseDComplexMatrix2D(n, n3) : dComplexMatrix2D2;
        if (dComplexMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort());
        }
        if (dComplexMatrix2D3.rows != n || dComplexMatrix2D3.columns != n3) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + dComplexMatrix2D.toStringShort() + ", " + dComplexMatrix2D3.toStringShort());
        }
        if (this == dComplexMatrix2D3 || dComplexMatrix2D == dComplexMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n5 = n3 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n3 : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    double[] s = new double[2];

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n; ++j) {
                                this.s[0] = 0.0;
                                this.s[1] = 0.0;
                                for (int k = 0; k < n2; ++k) {
                                    this.s = DComplex.plus(this.s, DComplex.mult(DComplexMatrix2D.this.getQuick(j, k), dComplexMatrix2D.getQuick(k, i)));
                                }
                                dComplexMatrix2D3.setQuick(j, i, DComplex.plus(DComplex.mult(this.s, dArray), DComplex.mult(dComplexMatrix2D3.getQuick(j, i), dArray2)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray3 = new double[2];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray3[0] = 0.0;
                    dArray3[1] = 0.0;
                    for (int k = 0; k < n2; ++k) {
                        dArray3 = DComplex.plus(dArray3, DComplex.mult(this.getQuick(j, k), dComplexMatrix2D.getQuick(k, i)));
                    }
                    dComplexMatrix2D3.setQuick(j, i, DComplex.plus(DComplex.mult(dArray3, dArray), DComplex.mult(dComplexMatrix2D3.getQuick(j, i), dArray2)));
                }
            }
        }
        dComplexMatrix2D2 = dComplexMatrix2D3;
        return dComplexMatrix2D2;
    }

    public double[] zSum() {
        if (this.size() == 0) {
            return new double[]{0.0, 0.0};
        }
        return this.aggregate(DComplexFunctions.plus, DComplexFunctions.identity);
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D == null) {
            return false;
        }
        if (this == dComplexMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(dComplexMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        return false;
    }

    protected abstract DComplexMatrix1D like1D(int var1, int var2, int var3);

    protected DComplexMatrix2D view() {
        return (DComplexMatrix2D)this.clone();
    }

    protected abstract DComplexMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

