/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1DProcedure;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class DComplexMatrix2DTest
extends TestCase {
    protected DComplexMatrix2D A;
    protected DComplexMatrix2D B;
    protected DComplexMatrix2D Bt;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected double TOL = 1.0E-10;

    public DComplexMatrix2DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < this.NCOLUMNS; ++n) {
                this.A.setQuick(n2, n, new double[]{Math.random(), Math.random()});
            }
        }
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < this.NCOLUMNS; ++n) {
                this.B.setQuick(n2, n, new double[]{Math.random(), Math.random()});
            }
        }
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            for (n = 0; n < this.NROWS; ++n) {
                this.Bt.setQuick(n2, n, new double[]{Math.random(), Math.random()});
            }
        }
    }

    protected void tearDown() throws Exception {
        this.Bt = null;
        this.B = null;
        this.A = null;
    }

    public void testAggregateComplexComplexComplexFunctionComplexComplexFunction() {
        double[] dArray = this.A.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
        double[] dArray2 = new double[2];
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                dArray2 = DComplex.plus(dArray2, DComplex.square(this.A.getQuick(i, j)));
            }
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testAggregateComplexMatrix2DComplexComplexComplexFunctionComplexComplexComplexFunction() {
        double[] dArray = this.A.aggregate(this.B, DComplexFunctions.plus, DComplexFunctions.mult);
        double[] dArray2 = new double[2];
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                dArray2 = DComplex.plus(dArray2, DComplex.mult(this.A.getQuick(i, j), this.B.getQuick(i, j)));
            }
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testAssignComplexComplexFunction() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assign(DComplexFunctions.acos);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = DComplex.acos(dComplexMatrix2D.getQuick(i, j));
                this.assertEquals(dArray, this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexMatrix2D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.B.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexMatrix2DComplexComplexComplexFunction() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assign(this.B, DComplexFunctions.div);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(DComplex.div(dComplexMatrix2D.getQuick(i, j), this.B.getQuick(i, j)), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexProcedureComplexComplexFunction() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assign(new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 3.0;
            }
        }, DComplexFunctions.tan);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                if (DComplex.abs(dComplexMatrix2D.getQuick(i, j)) > 3.0) {
                    this.assertEquals(DComplex.tan(dComplexMatrix2D.getQuick(i, j)), this.A.getQuick(i, j), this.TOL);
                    continue;
                }
                this.assertEquals(dComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexProcedureDoubleArray() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 3.0;
            }
        }, dArray);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                if (DComplex.abs(this.A.getQuick(i, j)) > 3.0) {
                    this.assertEquals(dArray, this.A.getQuick(i, j), this.TOL);
                    continue;
                }
                this.assertEquals(dComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testAssignComplexRealFunction() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assign(DComplexFunctions.abs);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = this.A.getQuick(i, j);
                DComplexMatrix2DTest.assertEquals((double)DComplex.abs(dComplexMatrix2D.getQuick(i, j)), (double)dArray[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleArray() {
        int n;
        double[] dArray = new double[2 * this.A.size()];
        for (n = 0; n < 2 * this.A.size(); ++n) {
            dArray[n] = Math.random();
        }
        this.A.assign(dArray);
        n = 0;
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray2 = this.A.getQuick(i, j);
                DComplexMatrix2DTest.assertEquals((double)dArray[n], (double)dArray2[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)dArray[n + 1], (double)dArray2[1], (double)this.TOL);
                n += 2;
            }
        }
    }

    public void testAssignDoubleArrayArray() {
        int n;
        int n2;
        double[][] dArray = new double[this.NROWS][2 * this.NCOLUMNS];
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < 2 * this.NCOLUMNS; ++n) {
                dArray[n2][n] = Math.random();
            }
        }
        this.A.assign(dArray);
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            for (n = 0; n < this.NCOLUMNS; ++n) {
                double[] dArray2 = this.A.getQuick(n2, n);
                DComplexMatrix2DTest.assertEquals((double)dArray[n2][2 * n], (double)dArray2[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)dArray[n2][2 * n + 1], (double)dArray2[1], (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleDouble() {
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(dArray[0], dArray[1]);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray2 = this.A.getQuick(i, j);
                this.assertEquals(dArray, dArray2, this.TOL);
            }
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[this.NROWS * 2 * this.NCOLUMNS];
        for (n = 0; n < 2 * this.A.size(); ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                double[] dArray = this.A.getQuick(i, j);
                DComplexMatrix2DTest.assertEquals((double)fArray[n], (double)dArray[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)fArray[n + 1], (double)dArray[1], (double)this.TOL);
                n += 2;
            }
        }
    }

    public void testAssignImaginary() {
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.random(this.NROWS, this.NCOLUMNS);
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assignImaginary(doubleMatrix2D);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DComplexMatrix2DTest.assertEquals((double)dComplexMatrix2D.getQuick(i, j)[0], (double)this.A.getQuick(i, j)[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)this.A.getQuick(i, j)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignReal() {
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.random(this.NROWS, this.NCOLUMNS);
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assignReal(doubleMatrix2D);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DComplexMatrix2DTest.assertEquals((double)dComplexMatrix2D.getQuick(i, j)[1], (double)this.A.getQuick(i, j)[1], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)this.A.getQuick(i, j)[0], (double)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)n);
    }

    public void testEqualsDoubleArray() {
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(dArray[0], dArray[1]);
        boolean bl = this.A.equals(dArray);
        DComplexMatrix2DTest.assertEquals((boolean)true, (boolean)bl);
        bl = this.A.equals(new double[]{dArray[0] + 1.0, dArray[1] + 1.0});
        DComplexMatrix2DTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        DComplexMatrix2DTest.assertEquals((boolean)true, (boolean)bl);
        bl = this.A.equals(this.B);
        DComplexMatrix2DTest.assertEquals((boolean)false, (boolean)bl);
    }

    public void testForEachNonZero() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        IntIntDComplexFunction intIntDComplexFunction = new IntIntDComplexFunction(){

            public double[] apply(int n, int n2, double[] dArray) {
                return DComplex.sqrt(dArray);
            }
        };
        this.A.forEachNonZero(intIntDComplexFunction);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(DComplex.sqrt(dComplexMatrix2D.getQuick(i, j)), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testGetConjugateTranspose() {
        DComplexMatrix2D dComplexMatrix2D = this.A.getConjugateTranspose();
        DComplexMatrix2DTest.assertEquals((int)this.A.rows(), (int)dComplexMatrix2D.columns());
        DComplexMatrix2DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DComplexMatrix2DTest.assertEquals((double)this.A.getQuick(i, j)[0], (double)dComplexMatrix2D.getQuick(j, i)[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)(-this.A.getQuick(i, j)[1]), (double)dComplexMatrix2D.getQuick(j, i)[1], (double)this.TOL);
            }
        }
    }

    public void testGetImaginaryPart() {
        DoubleMatrix2D doubleMatrix2D = this.A.getImaginaryPart();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DComplexMatrix2DTest.assertEquals((double)this.A.getQuick(i, j)[1], (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testGetNonZeros() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        this.A.getNonZeros(intArrayList, intArrayList2, arrayList);
        DComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)intArrayList.size());
        DComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)intArrayList2.size());
        DComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)arrayList.size());
        int n = 0;
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(intArrayList.get(n), intArrayList2.get(n)), arrayList.get(n), this.TOL);
                ++n;
            }
        }
    }

    public void testGetRealPart() {
        DoubleMatrix2D doubleMatrix2D = this.A.getRealPart();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DComplexMatrix2DTest.assertEquals((double)this.A.getQuick(i, j)[0], (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testToArray() {
        double[][] dArray = this.A.toArray();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DComplexMatrix2DTest.assertEquals((double)this.A.getQuick(i, j)[0], (double)dArray[i][2 * j], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)this.A.getQuick(i, j)[1], (double)dArray[i][2 * j + 1], (double)this.TOL);
            }
        }
    }

    public void testVectorize() {
        DComplexMatrix1D dComplexMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                this.assertEquals(this.A.getQuick(j, i), dComplexMatrix1D.getQuick(n++), this.TOL);
            }
        }
    }

    public void testViewColumn() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DComplexMatrix2DTest.assertEquals((int)this.NROWS, (int)dComplexMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            this.assertEquals(this.A.getQuick(i, this.NCOLUMNS / 2), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewColumnFlip() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewColumnFlip();
        DComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)dComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, this.NCOLUMNS - 1 - j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewDice() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewDice();
        DComplexMatrix2DTest.assertEquals((int)this.A.rows(), (int)dComplexMatrix2D.columns());
        DComplexMatrix2DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, j), dComplexMatrix2D.getQuick(j, i), this.TOL);
            }
        }
    }

    public void testViewPart() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewRow() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewRow(this.NROWS / 2);
        DComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)dComplexMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            this.assertEquals(this.A.getQuick(this.NROWS / 2, i), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewRowFlip() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewRowFlip();
        DComplexMatrix2DTest.assertEquals((int)this.A.size(), (int)dComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS - 1 - i, j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewSelectionComplexMatrix1DProcedure() {
        final double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.setQuick(this.NROWS / 3, 0, dArray);
        this.A.setQuick(this.NROWS / 2, 0, dArray);
        DComplexMatrix2D dComplexMatrix2D = this.A.viewSelection(new DComplexMatrix1DProcedure(){

            public boolean apply(DComplexMatrix1D dComplexMatrix1D) {
                return DComplex.isEqual(dComplexMatrix1D.getQuick(0), dArray, DComplexMatrix2DTest.this.TOL);
            }
        });
        DComplexMatrix2DTest.assertEquals((int)2, (int)dComplexMatrix2D.rows());
        DComplexMatrix2DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix2D.columns());
        this.assertEquals(this.A.getQuick(this.NROWS / 3, 0), dComplexMatrix2D.getQuick(0, 0), this.TOL);
        this.assertEquals(this.A.getQuick(this.NROWS / 2, 0), dComplexMatrix2D.getQuick(1, 0), this.TOL);
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NCOLUMNS / 6, this.NCOLUMNS / 5, this.NCOLUMNS / 4, this.NCOLUMNS / 3, this.NCOLUMNS / 2, this.NCOLUMNS - 1};
        DComplexMatrix2D dComplexMatrix2D = this.A.viewSelection(nArray, nArray2);
        DComplexMatrix2DTest.assertEquals((int)nArray.length, (int)dComplexMatrix2D.rows());
        DComplexMatrix2DTest.assertEquals((int)nArray2.length, (int)dComplexMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                this.assertEquals(this.A.getQuick(nArray[i], nArray2[j]), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        DComplexMatrix2D dComplexMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < dComplexMatrix2D.rows(); ++i) {
            for (int j = 0; j < dComplexMatrix2D.columns(); ++j) {
                this.assertEquals(this.A.getQuick(i * n, j * n2), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testZMultDComplexMatrix1DDComplexMatrix1DDComplexDComplexBoolean() {
        int n;
        double[] dArray;
        int n2;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.NCOLUMNS);
        for (int i = 0; i < denseDComplexMatrix1D.size(); ++i) {
            ((DComplexMatrix1D)denseDComplexMatrix1D).setQuick(i, new double[]{Math.random(), Math.random()});
        }
        double[] dArray2 = new double[]{3.0, 2.0};
        double[] dArray3 = new double[]{5.0, 4.0};
        DComplexMatrix1D dComplexMatrix1D = null;
        dComplexMatrix1D = this.A.zMult(denseDComplexMatrix1D, dComplexMatrix1D, dArray2, dArray3, false);
        double[] dArray4 = new double[2 * this.NROWS];
        double[] dArray5 = new double[2];
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            dArray = new double[2];
            for (n = 0; n < this.NCOLUMNS; ++n) {
                dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), ((DComplexMatrix1D)denseDComplexMatrix1D).getQuick(n)));
            }
            dArray5[0] = dArray4[2 * n2];
            dArray5[1] = dArray4[2 * n2 + 1];
            dArray5 = DComplex.mult(dArray3, dArray5);
            dArray5 = DComplex.plus(dArray5, DComplex.mult(dArray2, dArray));
            dArray4[2 * n2] = dArray5[0];
            dArray4[2 * n2 + 1] = dArray5[1];
        }
        for (n2 = 0; n2 < this.NROWS; ++n2) {
            DComplexMatrix2DTest.assertEquals((double)dArray4[2 * n2], (double)dComplexMatrix1D.getQuick(n2)[0], (double)this.TOL);
            DComplexMatrix2DTest.assertEquals((double)dArray4[2 * n2 + 1], (double)dComplexMatrix1D.getQuick(n2)[1], (double)this.TOL);
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.NROWS);
        for (n2 = 0; n2 < denseDComplexMatrix1D.size(); ++n2) {
            ((DComplexMatrix1D)denseDComplexMatrix1D).setQuick(n2, new double[]{Math.random(), Math.random()});
        }
        dComplexMatrix1D = null;
        dComplexMatrix1D = this.A.zMult(denseDComplexMatrix1D, dComplexMatrix1D, dArray2, dArray3, true);
        dArray4 = new double[2 * this.NCOLUMNS];
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            dArray = new double[2];
            for (n = 0; n < this.NROWS; ++n) {
                dArray = DComplex.plus(dArray, DComplex.mult(DComplex.conj(this.A.getQuick(n, n2)), ((DComplexMatrix1D)denseDComplexMatrix1D).getQuick(n)));
            }
            dArray5[0] = dArray4[2 * n2];
            dArray5[1] = dArray4[2 * n2 + 1];
            dArray5 = DComplex.mult(dArray3, dArray5);
            dArray5 = DComplex.plus(dArray5, DComplex.mult(dArray2, dArray));
            dArray4[2 * n2] = dArray5[0];
            dArray4[2 * n2 + 1] = dArray5[1];
        }
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            DComplexMatrix2DTest.assertEquals((double)dArray4[2 * n2], (double)dComplexMatrix1D.getQuick(n2)[0], (double)this.TOL);
            DComplexMatrix2DTest.assertEquals((double)dArray4[2 * n2 + 1], (double)dComplexMatrix1D.getQuick(n2)[1], (double)this.TOL);
        }
    }

    public void testZMultDoubleMatrix2DDoubleMatrix2DDoubleDoubleBooleanBoolean() {
        int n;
        double[] dArray;
        int n2;
        int n3;
        double[] dArray2 = new double[]{3.0, 2.0};
        double[] dArray3 = new double[]{5.0, 4.0};
        double[] dArray4 = new double[2];
        DComplexMatrix2D dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.Bt, dComplexMatrix2D, dArray2, dArray3, false, false);
        double[][] dArray5 = new double[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), this.Bt.getQuick(n, n3)));
                }
                dArray4[0] = dArray5[n2][2 * n3];
                dArray4[1] = dArray5[n2][2 * n3 + 1];
                dArray4 = DComplex.mult(dArray4, dArray3);
                dArray4 = DComplex.plus(dArray4, DComplex.mult(dArray, dArray2));
                dArray5[n2][2 * n3] = dArray4[0];
                dArray5[n2][2 * n3 + 1] = dArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.B, dComplexMatrix2D, dArray2, dArray3, true, false);
        dArray5 = new double[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NROWS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(DComplex.conj(this.A.getQuick(n, n2)), this.B.getQuick(n, n3)));
                }
                dArray4[0] = dArray5[n2][2 * n3];
                dArray4[1] = dArray5[n2][2 * n3 + 1];
                dArray4 = DComplex.mult(dArray4, dArray3);
                dArray4 = DComplex.plus(dArray4, DComplex.mult(dArray, dArray2));
                dArray5[n2][2 * n3] = dArray4[0];
                dArray5[n2][2 * n3 + 1] = dArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.B, dComplexMatrix2D, dArray2, dArray3, false, true);
        dArray5 = new double[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), DComplex.conj(this.B.getQuick(n3, n))));
                }
                dArray4[0] = dArray5[n2][2 * n3];
                dArray4[1] = dArray5[n2][2 * n3 + 1];
                dArray4 = DComplex.mult(dArray4, dArray3);
                dArray4 = DComplex.plus(dArray4, DComplex.mult(dArray, dArray2));
                dArray5[n2][2 * n3] = dArray4[0];
                dArray5[n2][2 * n3 + 1] = dArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.Bt, dComplexMatrix2D, dArray2, dArray3, true, true);
        dArray5 = new double[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NROWS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(DComplex.conj(this.A.getQuick(n, n2)), DComplex.conj(this.Bt.getQuick(n3, n))));
                }
                dArray4[0] = dArray5[n2][2 * n3];
                dArray4[1] = dArray5[n2][2 * n3 + 1];
                dArray4 = DComplex.mult(dArray4, dArray3);
                dArray4 = DComplex.plus(dArray4, DComplex.mult(dArray, dArray2));
                dArray5[n2][2 * n3] = dArray4[0];
                dArray5[n2][2 * n3 + 1] = dArray4[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DComplexMatrix2DTest.assertEquals((double)dArray5[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
    }

    public void testZSum() {
        double[] dArray = this.A.zSum();
        double[] dArray2 = new double[2];
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                dArray2 = DComplex.plus(dArray2, this.A.getQuick(i, j));
            }
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    protected void assertEquals(double[] dArray, double[] dArray2, double d) {
        for (int i = 0; i < dArray2.length; ++i) {
            DComplexMatrix2DTest.assertEquals((double)dArray[i], (double)dArray2[i], (double)d);
        }
    }
}

