/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDComplexMatrix1D {
    private static final Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDComplexMatrix1D.txt";
    private static double[] noViewTimes;
    private static double[] viewTimes;
    private static double[] a;
    private static double[] b;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdcomplex.impl.BenchmarkDenseDComplexMatrix1D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        BenchmarkMatrixKernel.readSettings1D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        a = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++n) {
            BenchmarkDenseDComplexMatrix1D.a[n] = random.nextDouble();
        }
        b = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++n) {
            BenchmarkDenseDComplexMatrix1D.b[n] = random.nextDouble();
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
        BenchmarkMatrixKernel.displayProperties(new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a = null;
        b = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDComplexDComplexDComplexFunctionDComplexDComplexFunction() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = ((DComplexMatrix1D)denseDComplexMatrix1D).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix1D)denseDComplexMatrix1D).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix1D.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix1D.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DComplexDComplexDComplexFunction, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDComplexMatrix1DDComplexDComplexDComplexFunctionDComplexDComplexDComplexFunction() {
        int n;
        Object object;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = ((DComplexMatrix1D)denseDComplexMatrix1D).aggregate(denseDComplexMatrix1D2, DComplexFunctions.plus, DComplexFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = ((DComplexMatrix1D)denseDComplexMatrix1D).aggregate(denseDComplexMatrix1D2, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        object = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = dComplexMatrix1D.aggregate((DComplexMatrix1D)object, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix1D.aggregate((DComplexMatrix1D)object, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DComplexMatrix1D, DComplexDComplexDComplexFunction, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleDouble() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        double d = Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(d, d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(d, d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix1D.assign(d, d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix1D.assign(d, d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(a);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(a);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix1D.assign(a);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix1D.assign(a);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexDComplexFunction() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(DComplexFunctions.acos);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(DComplexFunctions.acos);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix1D.assign(DComplexFunctions.acos);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(a);
                t.reset().start();
                dComplexMatrix1D.assign(DComplexFunctions.acos);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix1D() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(denseDComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(denseDComplexMatrix1D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D2 = denseDComplexMatrix1D2.viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix1D.assign(dComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix1D.assign(dComplexMatrix1D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix1DDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(b);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(denseDComplexMatrix1D2, DComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(denseDComplexMatrix1D2, DComplexFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        DComplexMatrix1D dComplexMatrix1D2 = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix1D.assign(dComplexMatrix1D2, DComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(a);
                t.reset().start();
                dComplexMatrix1D.assign(dComplexMatrix1D2, DComplexFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexMatrix1D, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDoubleArray() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        double[] dArray = new double[]{-1.0, -2.0};
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(dComplexProcedure, dArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(dComplexProcedure, dArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix1D.assign(dComplexProcedure, dArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(a);
                t.reset().start();
                dComplexMatrix1D.assign(dComplexProcedure, dArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexProcedure, double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDComplexDComplexFunction() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).assign(dComplexProcedure, DComplexFunctions.tan);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(a);
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).assign(dComplexProcedure, DComplexFunctions.tan);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix1D.assign(dComplexProcedure, DComplexFunctions.tan);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(a);
                t.reset().start();
                dComplexMatrix1D.assign(dComplexProcedure, DComplexFunctions.tan);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexProcedure, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = denseDComplexMatrix1D.cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = denseDComplexMatrix1D.cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = dComplexMatrix1D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = dComplexMatrix1D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix1D doubleMatrix1D = ((DComplexMatrix1D)denseDComplexMatrix1D).getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = ((DComplexMatrix1D)denseDComplexMatrix1D).getImaginaryPart();
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            DoubleMatrix1D doubleMatrix1D = dComplexMatrix1D.getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = dComplexMatrix1D.getImaginaryPart();
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix1D doubleMatrix1D = ((DComplexMatrix1D)denseDComplexMatrix1D).getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = ((DComplexMatrix1D)denseDComplexMatrix1D).getRealPart();
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            DoubleMatrix1D doubleMatrix1D = dComplexMatrix1D.getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix1D = dComplexMatrix1D.getRealPart();
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseDComplexMatrix1D.fft();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix1D.assign(a);
                t.reset().start();
                denseDComplexMatrix1D.fft();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseDComplexMatrix1D)dComplexMatrix1D).fft();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(a);
                t.reset().start();
                ((DenseDComplexMatrix1D)dComplexMatrix1D).fft();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft() {
        int n;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseDComplexMatrix1D.ifft(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix1D.assign(a);
                t.reset().start();
                denseDComplexMatrix1D.ifft(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseDComplexMatrix1D)dComplexMatrix1D).ifft(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix1D.assign(a);
                t.reset().start();
                ((DenseDComplexMatrix1D)dComplexMatrix1D).ifft(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntInt() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 64;
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            DComplexMatrix2D dComplexMatrix2D = ((DComplexMatrix1D)denseDComplexMatrix1D).reshape(n, n2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix2D = ((DComplexMatrix1D)denseDComplexMatrix1D).reshape(n, n2);
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        int n6 = 0;
        while (n6 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n6]);
            DComplexMatrix2D dComplexMatrix2D = dComplexMatrix1D.reshape(n, n2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix2D = dComplexMatrix1D.reshape(n, n2);
                t.stop();
                int n7 = n6;
                viewTimes[n7] = viewTimes[n7] + t.millis();
            }
            int n8 = n6++;
            viewTimes[n8] = viewTimes[n8] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "reshape(int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntIntInt() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DComplexMatrix3D dComplexMatrix3D = ((DComplexMatrix1D)denseDComplexMatrix1D).reshape(n, n2, n3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix3D = ((DComplexMatrix1D)denseDComplexMatrix1D).reshape(n, n2, n3);
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            DComplexMatrix3D dComplexMatrix3D = dComplexMatrix1D.reshape(n, n2, n3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix3D = dComplexMatrix1D.reshape(n, n2, n3);
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "reshape(int, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSwapDComplexMatrix1D() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(b);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix1D)denseDComplexMatrix1D).swap(denseDComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                ((DComplexMatrix1D)denseDComplexMatrix1D).swap(denseDComplexMatrix1D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(b);
        DComplexMatrix1D dComplexMatrix1D2 = denseDComplexMatrix1D2.viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix1D.swap(dComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix1D.swap(dComplexMatrix1D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "swap(DComplexMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArrayDoubleArray() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = denseDComplexMatrix1D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = denseDComplexMatrix1D.toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix1D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix1D.toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZDotProductDComplexMatrix1DIntInt() {
        int n;
        Object object;
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = denseDComplexMatrix1D.zDotProduct(denseDComplexMatrix1D2, 5, denseDComplexMatrix1D2.size() - 10);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = denseDComplexMatrix1D.zDotProduct(denseDComplexMatrix1D2, 5, denseDComplexMatrix1D2.size() - 10);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        DComplexMatrix1D dComplexMatrix1D = denseDComplexMatrix1D.viewFlip();
        denseDComplexMatrix1D2 = new DenseDComplexMatrix1D(b);
        object = denseDComplexMatrix1D2.viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = dComplexMatrix1D.zDotProduct((DComplexMatrix1D)object, 5, ((AbstractMatrix1D)object).size() - 10);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix1D.zDotProduct((DComplexMatrix1D)object, 5, ((AbstractMatrix1D)object).size() - 10);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zDotProduct(DComplexMatrix1D, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZSum() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = ((DComplexMatrix1D)denseDComplexMatrix1D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix1D)denseDComplexMatrix1D).zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix1D dComplexMatrix1D = new DenseDComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix1D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix1D.zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

