/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 7295427570770814934L;
    private DoubleFFT_1D fft;
    protected double[] elements;

    public DenseDComplexMatrix1D(double[] dArray) {
        this(dArray.length / 2);
        this.assign(dArray);
    }

    public DenseDComplexMatrix1D(DoubleMatrix1D doubleMatrix1D) {
        this(doubleMatrix1D.size());
        this.assignReal(doubleMatrix1D);
    }

    public DenseDComplexMatrix1D(int n) {
        this.setUp(n, 0, 2);
        this.isNoView = true;
        this.elements = new double[2 * n];
    }

    public DenseDComplexMatrix1D(int n, double[] dArray, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = dArray;
        this.isNoView = false;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        if (this.size == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        double[] dArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            double[][] dArray3 = new double[n][2];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = DenseDComplexMatrix1D.this.zero + n3 * DenseDComplexMatrix1D.this.stride;
                        double[] dArray = dComplexDComplexFunction.apply(new double[]{DenseDComplexMatrix1D.this.elements[n], DenseDComplexMatrix1D.this.elements[n + 1]});
                        for (int i = n3 + 1; i < n4; ++i) {
                            dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(new double[]{DenseDComplexMatrix1D.this.elements[n += DenseDComplexMatrix1D.this.stride], DenseDComplexMatrix1D.this.elements[n + 1]}));
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexFunction.apply(new double[]{this.elements[this.zero], this.elements[this.zero + 1]});
            int n5 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(new double[]{this.elements[n5 += this.stride], this.elements[n5 + 1]}));
            }
        }
        return dArray2;
    }

    @Override
    public double[] aggregate(DComplexMatrix1D dComplexMatrix1D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        if (!(dComplexMatrix1D instanceof DenseDComplexMatrix1D)) {
            return super.aggregate(dComplexMatrix1D, dComplexDComplexDComplexFunction, dComplexDComplexDComplexFunction2);
        }
        this.checkSize(dComplexMatrix1D);
        if (this.size == 0) {
            double[] dArray = new double[]{Double.NaN, Double.NaN};
            return dArray;
        }
        final int n = (int)dComplexMatrix1D.index(0);
        final int n2 = dComplexMatrix1D.stride();
        final double[] dArray = (double[])dComplexMatrix1D.elements();
        double[] dArray2 = null;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            double[][] dArray3 = new double[n3][2];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        double[] dArray2 = dComplexDComplexDComplexFunction2.apply(new double[]{DenseDComplexMatrix1D.this.elements[n3], DenseDComplexMatrix1D.this.elements[n3 + 1]}, new double[]{dArray[n22], dArray[n22 + 1]});
                        for (int i = n5 + 1; i < n6; ++i) {
                            dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexDComplexFunction2.apply(new double[]{DenseDComplexMatrix1D.this.elements[n3 += DenseDComplexMatrix1D.this.stride], DenseDComplexMatrix1D.this.elements[n3 + 1]}, new double[]{dArray[n22 += n2], dArray[n22 + 1]}));
                        }
                        return dArray2;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            int n7 = this.zero;
            int n8 = n;
            dArray2 = dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[this.zero], this.elements[this.zero + 1]}, new double[]{dArray[n], dArray[n + 1]});
            for (int i = 1; i < this.size; ++i) {
                dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n7 += this.stride], this.elements[n7 + 1]}, new double[]{dArray[n8 += n2], dArray[n8 + 1]}));
            }
        }
        return dArray2;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Object[] objectArray;
            if (dComplexDComplexFunction instanceof DComplexMult && (objectArray = (Object[])((DComplexMult)dComplexDComplexFunction).multiplicator)[0] == 1.0 && objectArray[1] == 0.0) {
                return this;
            }
            objectArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                objectArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        int n = DenseDComplexMatrix1D.this.zero + n3 * DenseDComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            dArray[0] = DenseDComplexMatrix1D.this.elements[n];
                            dArray[1] = DenseDComplexMatrix1D.this.elements[n + 1];
                            dArray = dComplexDComplexFunction.apply(dArray);
                            DenseDComplexMatrix1D.this.elements[n] = dArray[0];
                            DenseDComplexMatrix1D.this.elements[n + 1] = dArray[1];
                            n += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(objectArray);
        } else {
            double[] dArray = new double[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                dArray[0] = this.elements[n5];
                dArray[1] = this.elements[n5 + 1];
                dArray = dComplexDComplexFunction.apply(dArray);
                this.elements[n5] = dArray[0];
                this.elements[n5 + 1] = dArray[1];
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        int n = DenseDComplexMatrix1D.this.zero + n3 * DenseDComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            dArray[0] = DenseDComplexMatrix1D.this.elements[n];
                            dArray[1] = DenseDComplexMatrix1D.this.elements[n + 1];
                            if (dComplexProcedure.apply(dArray)) {
                                dArray = dComplexDComplexFunction.apply(dArray);
                                DenseDComplexMatrix1D.this.elements[n] = dArray[0];
                                DenseDComplexMatrix1D.this.elements[n + 1] = dArray[1];
                            }
                            n += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                dArray[0] = this.elements[n5];
                dArray[1] = this.elements[n5 + 1];
                if (dComplexProcedure.apply(dArray)) {
                    dArray = dComplexDComplexFunction.apply(dArray);
                    this.elements[n5] = dArray[0];
                    this.elements[n5 + 1] = dArray[1];
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2];
                        int n = DenseDComplexMatrix1D.this.zero + n3 * DenseDComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            dArray2[0] = DenseDComplexMatrix1D.this.elements[n];
                            dArray2[1] = DenseDComplexMatrix1D.this.elements[n + 1];
                            if (dComplexProcedure.apply(dArray2)) {
                                DenseDComplexMatrix1D.this.elements[n] = dArray[0];
                                DenseDComplexMatrix1D.this.elements[n + 1] = dArray[1];
                            }
                            n += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                dArray2[0] = this.elements[n5];
                dArray2[1] = this.elements[n5 + 1];
                if (dComplexProcedure.apply(dArray2)) {
                    this.elements[n5] = dArray[0];
                    this.elements[n5 + 1] = dArray[1];
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final DComplexRealFunction dComplexRealFunction) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        int n = DenseDComplexMatrix1D.this.zero + n3 * DenseDComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            dArray[0] = DenseDComplexMatrix1D.this.elements[n];
                            dArray[1] = DenseDComplexMatrix1D.this.elements[n + 1];
                            dArray[0] = dComplexRealFunction.apply(dArray);
                            DenseDComplexMatrix1D.this.elements[n] = dArray[0];
                            DenseDComplexMatrix1D.this.elements[n + 1] = 0.0;
                            n += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                dArray[0] = this.elements[n5];
                dArray[1] = this.elements[n5 + 1];
                dArray[0] = dComplexRealFunction.apply(dArray);
                this.elements[n5] = dArray[0];
                this.elements[n5 + 1] = 0.0;
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(DComplexMatrix1D dComplexMatrix1D) {
        Object object;
        if (!(dComplexMatrix1D instanceof DenseDComplexMatrix1D)) {
            return super.assign(dComplexMatrix1D);
        }
        DenseDComplexMatrix1D denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D;
        if (denseDComplexMatrix1D == this) {
            return this;
        }
        this.checkSize(denseDComplexMatrix1D);
        if (this.isNoView && denseDComplexMatrix1D.isNoView) {
            System.arraycopy(denseDComplexMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseDComplexMatrix1D)) {
            object = denseDComplexMatrix1D.copy();
            if (!(object instanceof DenseDComplexMatrix1D)) {
                return super.assign(dComplexMatrix1D);
            }
            denseDComplexMatrix1D = (DenseDComplexMatrix1D)object;
        }
        object = denseDComplexMatrix1D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n = denseDComplexMatrix1D.stride;
        final int n2 = (int)denseDComplexMatrix1D.index(0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((double[])object){
                    final /* synthetic */ double[] val$elemsOther;
                    {
                        this.val$elemsOther = dArray;
                    }

                    public void run() {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n2 + n5 * n;
                        for (int i = n5; i < n6; ++i) {
                            DenseDComplexMatrix1D.this.elements[n3] = this.val$elemsOther[n22];
                            DenseDComplexMatrix1D.this.elements[n3 + 1] = this.val$elemsOther[n22 + 1];
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n2;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = (double)object[n8];
                this.elements[n7 + 1] = (double)object[n8 + 1];
                n7 += this.stride;
                n8 += n;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(DComplexMatrix1D dComplexMatrix1D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        if (!(dComplexMatrix1D instanceof DenseDComplexMatrix1D)) {
            return super.assign(dComplexMatrix1D, dComplexDComplexDComplexFunction);
        }
        this.checkSize(dComplexMatrix1D);
        final double[] dArray = (double[])dComplexMatrix1D.elements();
        final int n = (int)dComplexMatrix1D.index(0);
        final int n2 = dComplexMatrix1D.stride();
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray3 = new double[2];
                        double[] dArray2 = new double[2];
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            dArray3[0] = DenseDComplexMatrix1D.this.elements[n3];
                            dArray3[1] = DenseDComplexMatrix1D.this.elements[n3 + 1];
                            dArray2[0] = dArray[n22];
                            dArray2[1] = dArray[n22 + 1];
                            dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dArray2);
                            DenseDComplexMatrix1D.this.elements[n3] = dArray3[0];
                            DenseDComplexMatrix1D.this.elements[n3 + 1] = dArray3[1];
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                dArray2[0] = this.elements[n7];
                dArray2[1] = this.elements[n7 + 1];
                dArray3[0] = dArray[n8];
                dArray3[1] = dArray[n8 + 1];
                dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dArray3);
                this.elements[n7] = dArray2[0];
                this.elements[n7 + 1] = dArray2[1];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(final double d, final double d2) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseDComplexMatrix1D.this.zero + n3 * DenseDComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseDComplexMatrix1D.this.elements[n] = d;
                            DenseDComplexMatrix1D.this.elements[n + 1] = d2;
                            n += DenseDComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = d;
                this.elements[n5 + 1] = d2;
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assign(double[] dArray) {
        if (this.isNoView) {
            if (dArray.length != 2 * this.size) {
                throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + 2 * this.size());
            }
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assignImaginary(DoubleMatrix1D doubleMatrix1D) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.assignImaginary(doubleMatrix1D);
        }
        this.checkSize(doubleMatrix1D);
        final int n = (int)doubleMatrix1D.index(0);
        final int n2 = doubleMatrix1D.stride();
        final double[] dArray = (double[])doubleMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseDComplexMatrix1D.this.elements[n3 + 1] = dArray[n22];
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7 + 1] = dArray[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix1D assignReal(DoubleMatrix1D doubleMatrix1D) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.assignReal(doubleMatrix1D);
        }
        this.checkSize(doubleMatrix1D);
        final int n = (int)doubleMatrix1D.index(0);
        final int n2 = doubleMatrix1D.stride();
        final double[] dArray = (double[])doubleMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseDComplexMatrix1D.this.elements[n3] = dArray[n22];
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = dArray[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public void fft() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexForward(this.elements);
        } else {
            DComplexMatrix1D dComplexMatrix1D = this.copy();
            this.fft.complexForward((double[])dComplexMatrix1D.elements());
            this.assign((double[])dComplexMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size);
        final double[] dArray = denseDoubleMatrix1D.elements();
        final int n = (int)denseDoubleMatrix1D.index(0);
        final int n2 = denseDoubleMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            dArray[n22] = DenseDComplexMatrix1D.this.elements[n3 + 1];
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                dArray[n8] = this.elements[n7 + 1];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return denseDoubleMatrix1D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getNonZeros(IntArrayList intArrayList, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        arrayList.clear();
        int n = this.size();
        int n2 = this.zero;
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[]{this.elements[n2], this.elements[n2 + 1]};
            if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                IntArrayList intArrayList2 = intArrayList;
                synchronized (intArrayList2) {
                    intArrayList.add(i);
                    arrayList.add(dArray);
                }
            }
            n2 += this.stride;
        }
    }

    @Override
    public double[] getQuick(int n) {
        int n2 = this.zero + n * this.stride;
        return new double[]{this.elements[n2], this.elements[n2 + 1]};
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size);
        final double[] dArray = denseDoubleMatrix1D.elements();
        final int n = (int)denseDoubleMatrix1D.index(0);
        final int n2 = denseDoubleMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            dArray[n22] = DenseDComplexMatrix1D.this.elements[n3];
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                dArray[n8] = this.elements[n7];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return denseDoubleMatrix1D;
    }

    public void ifft(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexInverse(this.elements, bl);
        } else {
            DComplexMatrix1D dComplexMatrix1D = this.copy();
            this.fft.complexInverse((double[])dComplexMatrix1D.elements(), bl);
            this.assign((double[])dComplexMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    @Override
    public DComplexMatrix1D like(int n) {
        return new DenseDComplexMatrix1D(n);
    }

    @Override
    public DComplexMatrix2D like2D(int n, int n2) {
        return new DenseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(n, n2);
        final double[] dArray = (double[])((DComplexMatrix2D)denseDComplexMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseDComplexMatrix2D).index(0, 0);
        final int n4 = denseDComplexMatrix2D.rowStride();
        final int n5 = denseDComplexMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseDComplexMatrix1D.this.zero + i * n * DenseDComplexMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                dArray[n6] = DenseDComplexMatrix1D.this.elements[n2];
                                dArray[n6 + 1] = DenseDComplexMatrix1D.this.elements[n2 + 1];
                                n6 += n4;
                                n2 += DenseDComplexMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    dArray[n11] = this.elements[n10];
                    dArray[n11 + 1] = this.elements[n10 + 1];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseDComplexMatrix2D;
    }

    @Override
    public DComplexMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(n, n2, n3);
        final double[] dArray = (double[])((DComplexMatrix3D)denseDComplexMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseDComplexMatrix3D).index(0, 0, 0);
        final int n5 = denseDComplexMatrix3D.sliceStride();
        final int n6 = denseDComplexMatrix3D.rowStride();
        final int n7 = denseDComplexMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseDComplexMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseDComplexMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    dArray[n] = DenseDComplexMatrix1D.this.elements[n22];
                                    dArray[n + 1] = DenseDComplexMatrix1D.this.elements[n22 + 1];
                                    n += n6;
                                    n22 += DenseDComplexMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        dArray[n13] = this.elements[n12];
                        dArray[n13 + 1] = this.elements[n12 + 1];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseDComplexMatrix3D;
    }

    @Override
    public void setQuick(int n, double d, double d2) {
        int n2 = this.zero + n * this.stride;
        this.elements[n2] = d;
        this.elements[n2 + 1] = d2;
    }

    @Override
    public void setQuick(int n, double[] dArray) {
        int n2 = this.zero + n * this.stride;
        this.elements[n2] = dArray[0];
        this.elements[n2 + 1] = dArray[1];
    }

    @Override
    public void swap(DComplexMatrix1D dComplexMatrix1D) {
        DenseDComplexMatrix1D denseDComplexMatrix1D;
        if (!(dComplexMatrix1D instanceof DenseDComplexMatrix1D)) {
            super.swap(dComplexMatrix1D);
        }
        if ((denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D) == this) {
            return;
        }
        this.checkSize(denseDComplexMatrix1D);
        final double[] dArray = denseDComplexMatrix1D.elements;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        final int n = denseDComplexMatrix1D.stride;
        final int n2 = (int)denseDComplexMatrix1D.index(0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseDComplexMatrix1D.this.zero + n5 * DenseDComplexMatrix1D.this.stride;
                        int n22 = n2 + n5 * n;
                        for (int i = n5; i < n6; ++i) {
                            double d = DenseDComplexMatrix1D.this.elements[n3];
                            DenseDComplexMatrix1D.this.elements[n3] = dArray[n22];
                            dArray[n22] = d;
                            d = DenseDComplexMatrix1D.this.elements[n3 + 1];
                            DenseDComplexMatrix1D.this.elements[n3 + 1] = dArray[n22 + 1];
                            dArray[n22 + 1] = d;
                            n3 += DenseDComplexMatrix1D.this.stride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n2;
            for (int i = 0; i < this.size; ++i) {
                double d = this.elements[n7];
                this.elements[n7] = dArray[n8];
                dArray[n8] = d;
                d = this.elements[n7 + 1];
                this.elements[n7 + 1] = dArray[n8 + 1];
                dArray[n8 + 1] = d;
                n7 += this.stride;
                n8 += n;
            }
        }
    }

    @Override
    public void toArray(double[] dArray) {
        if (dArray.length < 2 * this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, dArray, 0, this.elements.length);
        } else {
            super.toArray(dArray);
        }
    }

    @Override
    public double[] zSum() {
        double[] dArray = new double[2];
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n2;
            Future[] futureArray = new Future[n];
            double[][] dArray2 = new double[n][2];
            int n3 = this.size / n;
            for (n2 = 0; n2 < n; ++n2) {
                final int n4 = n2 * n3;
                final int n5 = n2 == n - 1 ? this.size : n4 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = new double[2];
                        int n = DenseDComplexMatrix1D.this.zero + n4 * DenseDComplexMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            dArray[0] = dArray[0] + DenseDComplexMatrix1D.this.elements[n];
                            dArray[1] = dArray[1] + DenseDComplexMatrix1D.this.elements[n + 1];
                            n += DenseDComplexMatrix1D.this.stride;
                        }
                        return dArray;
                    }
                });
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray2[n2] = (double[])futureArray[n2].get();
                }
                dArray = dArray2[0];
                for (n2 = 1; n2 < n; ++n2) {
                    dArray[0] = dArray[0] + dArray2[n2][0];
                    dArray[1] = dArray[1] + dArray2[n2][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                dArray[0] = dArray[0] + this.elements[n6];
                dArray[1] = dArray[1] + this.elements[n6 + 1];
                n6 += this.stride;
            }
        }
        return dArray;
    }

    @Override
    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.zero;
        for (int i = 0; i < this.size && n2 < n; ++i) {
            if (this.elements[n3] != 0.0 || this.elements[n3 + 1] != 0.0) {
                ++n2;
            }
            n3 += this.stride;
        }
        return n2;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D instanceof SelectedDenseDComplexMatrix1D) {
            SelectedDenseDComplexMatrix1D selectedDenseDComplexMatrix1D = (SelectedDenseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == selectedDenseDComplexMatrix1D.elements;
        }
        if (dComplexMatrix1D instanceof DenseDComplexMatrix1D) {
            DenseDComplexMatrix1D denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == denseDComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return this.zero + n * this.stride;
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseDComplexMatrix1D(this.elements, nArray);
    }
}

