/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 3008992680697668332L;
    private DoubleFFT_3D fft3;
    protected double[] elements;

    public DenseDComplexMatrix3D(double[][][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, dArray.length == 0 ? 0 : (dArray[0].length == 0 ? 0 : dArray[0][0].length / 2));
        this.assign(dArray);
    }

    public DenseDComplexMatrix3D(DoubleMatrix3D doubleMatrix3D) {
        this(doubleMatrix3D.slices(), doubleMatrix3D.rows(), doubleMatrix3D.columns());
        this.assignReal(doubleMatrix3D);
    }

    public DenseDComplexMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3, 0, 0, 0, n2 * 2 * n3, 2 * n3, 2);
        this.elements = new double[n * n2 * 2 * n3];
    }

    public DenseDComplexMatrix3D(int n, int n2, int n3, double[] dArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = dArray;
        this.isNoView = false;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        if (this.size() == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        final int n = (int)this.index(0, 0, 0);
        double[] dArray2 = null;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            double[][] dArray3 = new double[n2][2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n3 = n + n4 * DenseDComplexMatrix3D.this.sliceStride;
                        double[] dArray = dComplexDComplexFunction.apply(new double[]{DenseDComplexMatrix3D.this.elements[n3], DenseDComplexMatrix3D.this.elements[n3 + 1]});
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    n3 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride + k * DenseDComplexMatrix3D.this.columnStride;
                                    dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(new double[]{DenseDComplexMatrix3D.this.elements[n3], DenseDComplexMatrix3D.this.elements[n3 + 1]}));
                                }
                                n2 = 0;
                            }
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexFunction.apply(new double[]{this.elements[n], this.elements[n + 1]});
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        int n7 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(new double[]{this.elements[n7], this.elements[n7 + 1]}));
                    }
                    n6 = 0;
                }
            }
        }
        return dArray2;
    }

    @Override
    public double[] aggregate(DComplexMatrix3D dComplexMatrix3D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        this.checkShape(dComplexMatrix3D);
        double[] dArray = new double[2];
        if (this.size() == 0) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)dComplexMatrix3D.index(0, 0, 0);
        final int n3 = dComplexMatrix3D.sliceStride();
        final int n4 = dComplexMatrix3D.rowStride();
        final int n5 = dComplexMatrix3D.columnStride();
        final double[] dArray2 = (double[])dComplexMatrix3D.elements();
        double[] dArray3 = null;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            double[][] dArray4 = new double[n6][2];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n6 = n + n8 * DenseDComplexMatrix3D.this.sliceStride;
                        int n22 = n2 + n8 * n3;
                        double[] dArray = dComplexDComplexDComplexFunction2.apply(new double[]{DenseDComplexMatrix3D.this.elements[n6], DenseDComplexMatrix3D.this.elements[n6 + 1]}, new double[]{dArray2[n22], dArray2[n22 + 1]});
                        int n32 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                for (int k = n32; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    n6 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride + k * DenseDComplexMatrix3D.this.columnStride;
                                    n22 = n2 + i * n3 + j * n4 + k * n5;
                                    dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(new double[]{DenseDComplexMatrix3D.this.elements[n6], DenseDComplexMatrix3D.this.elements[n6 + 1]}, new double[]{dArray2[n22], dArray2[n22 + 1]}));
                                }
                                n32 = 0;
                            }
                        }
                        return dArray;
                    }
                });
            }
            dArray3 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray3 = dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n], this.elements[n + 1]}, new double[]{dArray2[n2], dArray2[n2 + 1]});
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n12 = n2 + i * n3 + j * n4 + k * n5;
                        dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dComplexDComplexDComplexFunction2.apply(new double[]{this.elements[n11], this.elements[n11 + 1]}, new double[]{dArray2[n12], dArray2[n12 + 1]}));
                    }
                    n10 = 0;
                }
            }
        }
        return dArray3;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray[0] = DenseDComplexMatrix3D.this.elements[n2];
                                    dArray[1] = DenseDComplexMatrix3D.this.elements[n2 + 1];
                                    dArray = dComplexDComplexFunction.apply(dArray);
                                    DenseDComplexMatrix3D.this.elements[n2] = dArray[0];
                                    DenseDComplexMatrix3D.this.elements[n2 + 1] = dArray[1];
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[0] = this.elements[n6];
                        dArray[1] = this.elements[n6 + 1];
                        dArray = dComplexDComplexFunction.apply(dArray);
                        this.elements[n6] = dArray[0];
                        this.elements[n6 + 1] = dArray[1];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray[0] = DenseDComplexMatrix3D.this.elements[n2];
                                    dArray[1] = DenseDComplexMatrix3D.this.elements[n2 + 1];
                                    if (dComplexProcedure.apply(dArray)) {
                                        dArray = dComplexDComplexFunction.apply(dArray);
                                        DenseDComplexMatrix3D.this.elements[n2] = dArray[0];
                                        DenseDComplexMatrix3D.this.elements[n2 + 1] = dArray[1];
                                    }
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[0] = this.elements[n6];
                        dArray[1] = this.elements[n6 + 1];
                        if (dComplexProcedure.apply(dArray)) {
                            dArray = dComplexDComplexFunction.apply(dArray);
                            this.elements[n6] = dArray[0];
                            this.elements[n6 + 1] = dArray[1];
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray2[0] = DenseDComplexMatrix3D.this.elements[n2];
                                    dArray2[1] = DenseDComplexMatrix3D.this.elements[n2 + 1];
                                    if (dComplexProcedure.apply(dArray2)) {
                                        DenseDComplexMatrix3D.this.elements[n2] = dArray[0];
                                        DenseDComplexMatrix3D.this.elements[n2 + 1] = dArray[1];
                                    }
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray2[0] = this.elements[n6];
                        dArray2[1] = this.elements[n6 + 1];
                        if (dComplexProcedure.apply(dArray2)) {
                            this.elements[n6] = dArray[0];
                            this.elements[n6 + 1] = dArray[1];
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final DComplexRealFunction dComplexRealFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray[0] = DenseDComplexMatrix3D.this.elements[n2];
                                    dArray[1] = DenseDComplexMatrix3D.this.elements[n2 + 1];
                                    dArray[0] = dComplexRealFunction.apply(dArray);
                                    DenseDComplexMatrix3D.this.elements[n2] = dArray[0];
                                    DenseDComplexMatrix3D.this.elements[n2 + 1] = 0.0;
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[0] = this.elements[n6];
                        dArray[1] = this.elements[n6 + 1];
                        dArray[0] = dComplexRealFunction.apply(dArray);
                        this.elements[n6] = dArray[0];
                        this.elements[n6 + 1] = 0.0;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(DComplexMatrix3D dComplexMatrix3D) {
        if (!(dComplexMatrix3D instanceof DenseDComplexMatrix3D)) {
            super.assign(dComplexMatrix3D);
            return this;
        }
        DenseDComplexMatrix3D denseDComplexMatrix3D = (DenseDComplexMatrix3D)dComplexMatrix3D;
        if (denseDComplexMatrix3D == this) {
            return this;
        }
        this.checkShape(denseDComplexMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseDComplexMatrix3D.isNoView) {
            System.arraycopy(denseDComplexMatrix3D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseDComplexMatrix3D denseDComplexMatrix3D2 = (DenseDComplexMatrix3D)dComplexMatrix3D;
        if (this.haveSharedCells(denseDComplexMatrix3D2)) {
            DComplexMatrix3D dComplexMatrix3D2 = denseDComplexMatrix3D2.copy();
            if (!(dComplexMatrix3D2 instanceof DenseDComplexMatrix3D)) {
                super.assign(dComplexMatrix3D);
                return this;
            }
            denseDComplexMatrix3D2 = (DenseDComplexMatrix3D)dComplexMatrix3D2;
        }
        final int n2 = (int)this.index(0, 0, 0);
        final int n3 = (int)denseDComplexMatrix3D2.index(0, 0, 0);
        final int n4 = denseDComplexMatrix3D2.sliceStride;
        final int n5 = denseDComplexMatrix3D2.rowStride;
        final int n6 = denseDComplexMatrix3D2.columnStride;
        final double[] dArray = denseDComplexMatrix3D2.elements;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n7 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                int n22 = n3 + i * n4 + j * n5;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    DenseDComplexMatrix3D.this.elements[n] = dArray[n22];
                                    DenseDComplexMatrix3D.this.elements[n + 1] = dArray[n22 + 1];
                                    n += DenseDComplexMatrix3D.this.columnStride;
                                    n22 += n6;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n2 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n3 + i * n4 + j * n5;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = dArray[n11];
                        this.elements[n10 + 1] = dArray[n11 + 1];
                        n10 += this.columnStride;
                        n11 += n6;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(DComplexMatrix3D dComplexMatrix3D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        this.checkShape(dComplexMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)dComplexMatrix3D.index(0, 0, 0);
        final int n3 = dComplexMatrix3D.columnStride();
        final int n4 = dComplexMatrix3D.sliceStride();
        final int n5 = dComplexMatrix3D.rowStride();
        final double[] dArray = (double[])dComplexMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray3 = new double[2];
                        double[] dArray2 = new double[2];
                        if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    int n6 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                    int n22 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                        dArray3[0] = DenseDComplexMatrix3D.this.elements[n6];
                                        dArray3[1] = DenseDComplexMatrix3D.this.elements[n6 + 1];
                                        dArray2[0] = dArray[n22];
                                        dArray2[1] = dArray[n22 + 1];
                                        DenseDComplexMatrix3D.this.elements[n6] = dArray3[0] * dArray2[0] - dArray3[1] * dArray2[1];
                                        DenseDComplexMatrix3D.this.elements[n6 + 1] = dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1];
                                        n6 += DenseDComplexMatrix3D.this.columnStride;
                                        n22 += n3;
                                    }
                                }
                            }
                        } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjFirst) {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    int n7 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                    int n32 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                        dArray3[0] = DenseDComplexMatrix3D.this.elements[n7];
                                        dArray3[1] = DenseDComplexMatrix3D.this.elements[n7 + 1];
                                        dArray2[0] = dArray[n32];
                                        dArray2[1] = dArray[n32 + 1];
                                        DenseDComplexMatrix3D.this.elements[n7] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1];
                                        DenseDComplexMatrix3D.this.elements[n7 + 1] = -dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1];
                                        n7 += DenseDComplexMatrix3D.this.columnStride;
                                        n32 += n3;
                                    }
                                }
                            }
                        } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjSecond) {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    int n10 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                    int n42 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                        dArray3[0] = DenseDComplexMatrix3D.this.elements[n10];
                                        dArray3[1] = DenseDComplexMatrix3D.this.elements[n10 + 1];
                                        dArray2[0] = dArray[n42];
                                        dArray2[1] = dArray[n42 + 1];
                                        DenseDComplexMatrix3D.this.elements[n10] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1];
                                        DenseDComplexMatrix3D.this.elements[n10 + 1] = dArray3[1] * dArray2[0] - dArray3[0] * dArray2[1];
                                        n10 += DenseDComplexMatrix3D.this.columnStride;
                                        n42 += n3;
                                    }
                                }
                            }
                        } else {
                            for (int i = n8; i < n9; ++i) {
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    int n11 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                    int n52 = n2 + i * n4 + j * n5;
                                    for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                        dArray3[0] = DenseDComplexMatrix3D.this.elements[n11];
                                        dArray3[1] = DenseDComplexMatrix3D.this.elements[n11 + 1];
                                        dArray2[0] = dArray[n52];
                                        dArray2[1] = dArray[n52 + 1];
                                        dArray3 = dComplexDComplexDComplexFunction.apply(dArray3, dArray2);
                                        DenseDComplexMatrix3D.this.elements[n11] = dArray3[0];
                                        DenseDComplexMatrix3D.this.elements[n11 + 1] = dArray3[1];
                                        n11 += DenseDComplexMatrix3D.this.columnStride;
                                        n52 += n3;
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n10 = n + i * this.sliceStride + j * this.rowStride;
                        int n11 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            dArray2[0] = this.elements[n10];
                            dArray2[1] = this.elements[n10 + 1];
                            dArray3[0] = dArray[n11];
                            dArray3[1] = dArray[n11 + 1];
                            this.elements[n10] = dArray2[0] * dArray3[0] - dArray2[1] * dArray3[1];
                            this.elements[n10 + 1] = dArray2[1] * dArray3[0] + dArray2[0] * dArray3[1];
                            n10 += this.columnStride;
                            n11 += n3;
                        }
                    }
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjFirst) {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n12 = n + i * this.sliceStride + j * this.rowStride;
                        int n13 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            dArray2[0] = this.elements[n12];
                            dArray2[1] = this.elements[n12 + 1];
                            dArray3[0] = dArray[n13];
                            dArray3[1] = dArray[n13 + 1];
                            this.elements[n12] = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1];
                            this.elements[n12 + 1] = -dArray2[1] * dArray3[0] + dArray2[0] * dArray3[1];
                            n12 += this.columnStride;
                            n13 += n3;
                        }
                    }
                }
            } else if (dComplexDComplexDComplexFunction == DComplexFunctions.multConjSecond) {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n14 = n + i * this.sliceStride + j * this.rowStride;
                        int n15 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            dArray2[0] = this.elements[n14];
                            dArray2[1] = this.elements[n14 + 1];
                            dArray3[0] = dArray[n15];
                            dArray3[1] = dArray[n15 + 1];
                            this.elements[n14] = dArray2[0] * dArray3[0] + dArray2[1] * dArray3[1];
                            this.elements[n14 + 1] = dArray2[1] * dArray3[0] - dArray2[0] * dArray3[1];
                            n14 += this.columnStride;
                            n15 += n3;
                        }
                    }
                }
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n16 = n + i * this.sliceStride + j * this.rowStride;
                        int n17 = n2 + i * n4 + j * n5;
                        for (int k = 0; k < this.columns; ++k) {
                            dArray2[0] = this.elements[n16];
                            dArray2[1] = this.elements[n16 + 1];
                            dArray3[0] = dArray[n17];
                            dArray3[1] = dArray[n17 + 1];
                            dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dArray3);
                            this.elements[n16] = dArray2[0];
                            this.elements[n16 + 1] = dArray2[1];
                            n16 += this.columnStride;
                            n17 += n3;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final double d, final double d2) {
        if (!this.isNoView) {
            return super.assign(d, d2);
        }
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    DenseDComplexMatrix3D.this.elements[n2] = d;
                                    DenseDComplexMatrix3D.this.elements[n2 + 1] = d2;
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = d;
                        this.elements[n6 + 1] = d2;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final double[] dArray) {
        if (dArray.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else {
            final int n2 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i * n3 * 2 * this.rows * this.columns;
                    final int n6 = i == n - 1 ? this.slices : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n5;
                            for (int i = n4; i < n6; ++i) {
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    int n22 = n2 + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                        DenseDComplexMatrix3D.this.elements[n22] = dArray[n++];
                                        DenseDComplexMatrix3D.this.elements[n22 + 1] = dArray[n++];
                                        n22 += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n8] = dArray[n7++];
                            this.elements[n8 + 1] = dArray[n7++];
                            n8 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assign(final double[][][] dArray) {
        if (dArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
        }
        final int n = 2 * this.columns;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n2];
                int n3 = this.slices / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n2 = n4 * DenseDComplexMatrix3D.this.sliceStride;
                            for (int i = n4; i < n5; ++i) {
                                double[][] dArray3 = dArray[i];
                                if (dArray3.length != DenseDComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray3.length + "rows()=" + DenseDComplexMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    double[] dArray2 = dArray3[j];
                                    if (dArray2.length != n) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2 * columns()=" + n);
                                    }
                                    System.arraycopy(dArray2, 0, DenseDComplexMatrix3D.this.elements, n2, n);
                                    n2 += n;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    double[][] dArray2 = dArray[i];
                    if (dArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        double[] dArray3 = dArray2[j];
                        if (dArray3.length != n) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "2 * columns()=" + n);
                        }
                        System.arraycopy(dArray3, 0, this.elements, n6, n);
                        n6 += n;
                    }
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0, 0);
            if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futureArray = new Future[n2];
                int n8 = this.slices / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n9 = i * n8;
                    final int n10 = i == n2 - 1 ? this.slices : n9 + n8;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n9; i < n10; ++i) {
                                double[][] dArray3 = dArray[i];
                                if (dArray3.length != DenseDComplexMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray3.length + "rows()=" + DenseDComplexMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                    int n2 = n7 + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                    double[] dArray2 = dArray3[j];
                                    if (dArray2.length != n) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + n);
                                    }
                                    for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                        DenseDComplexMatrix3D.this.elements[n2] = dArray2[2 * k];
                                        DenseDComplexMatrix3D.this.elements[n2 + 1] = dArray2[2 * k + 1];
                                        n2 += DenseDComplexMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    double[][] dArray4 = dArray[i];
                    if (dArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n11 = n7 + i * this.sliceStride + j * this.rowStride;
                        double[] dArray5 = dArray4[j];
                        if (dArray5.length != n) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray5.length + "2*columns()=" + n);
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n11] = dArray5[2 * k];
                            this.elements[n11 + 1] = dArray5[2 * k + 1];
                            n11 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assignImaginary(DoubleMatrix3D doubleMatrix3D) {
        this.checkShape(doubleMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)doubleMatrix3D.index(0, 0, 0);
        final int n3 = doubleMatrix3D.sliceStride();
        final int n4 = doubleMatrix3D.rowStride();
        final int n5 = doubleMatrix3D.columnStride();
        final double[] dArray = (double[])doubleMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    DenseDComplexMatrix3D.this.elements[n6 + 1] = dArray[n22];
                                    n6 += DenseDComplexMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10 + 1] = dArray[n11];
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix3D assignReal(DoubleMatrix3D doubleMatrix3D) {
        this.checkShape(doubleMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)doubleMatrix3D.index(0, 0, 0);
        final int n3 = doubleMatrix3D.sliceStride();
        final int n4 = doubleMatrix3D.rowStride();
        final int n5 = doubleMatrix3D.columnStride();
        final double[] dArray = (double[])doubleMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    DenseDComplexMatrix3D.this.elements[n6] = dArray[n22];
                                    n6 += DenseDComplexMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = dArray[n11];
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    if (DenseDComplexMatrix3D.this.elements[n22] != 0.0 || DenseDComplexMatrix3D.this.elements[n22 + 1] != 0.0) {
                                        ++n;
                                    }
                                    n22 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.elements[n8] != 0.0 || this.elements[n8 + 1] != 0.0) {
                            ++n;
                        }
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    public void fft2Slices() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.slices; ++i) {
            ((DenseDComplexMatrix2D)this.viewSlice(i)).fft2();
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexForward(this.elements);
        } else {
            DComplexMatrix3D dComplexMatrix3D = this.copy();
            this.fft3.complexForward((double[])dComplexMatrix3D.elements());
            this.assign((double[])dComplexMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix3D getImaginaryPart() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(this.slices, this.rows, this.columns);
        final double[] dArray = denseDoubleMatrix3D.elements();
        final int n = denseDoubleMatrix3D.sliceStride();
        final int n2 = denseDoubleMatrix3D.rowStride();
        final int n3 = denseDoubleMatrix3D.columnStride();
        final int n4 = (int)denseDoubleMatrix3D.index(0, 0, 0);
        final int n5 = (int)this.index(0, 0, 0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n6 = n5 + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                int n22 = n4 + i * n + j * n2;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray[n22] = DenseDComplexMatrix3D.this.elements[n6 + 1];
                                    n6 += DenseDComplexMatrix3D.this.columnStride;
                                    n22 += n3;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n5 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n4 + i * n + j * n2;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[n11] = this.elements[n10 + 1];
                        n10 += this.columnStride;
                        n11 += n3;
                    }
                }
            }
        }
        return denseDoubleMatrix3D;
    }

    @Override
    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        arrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    double[] dArray = new double[]{this.elements[n2], this.elements[n2 + 1]};
                    if (dArray[0] != 0.0 || dArray[1] != 0.0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        arrayList.add(dArray);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    @Override
    public double[] getQuick(int n, int n2, int n3) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        return new double[]{this.elements[n4], this.elements[n4 + 1]};
    }

    @Override
    public DoubleMatrix3D getRealPart() {
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(this.slices, this.rows, this.columns);
        final double[] dArray = denseDoubleMatrix3D.elements();
        final int n = denseDoubleMatrix3D.sliceStride();
        final int n2 = denseDoubleMatrix3D.rowStride();
        final int n3 = denseDoubleMatrix3D.columnStride();
        final int n4 = (int)denseDoubleMatrix3D.index(0, 0, 0);
        final int n5 = (int)this.index(0, 0, 0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n6 = n5 + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                int n22 = n4 + i * n + j * n2;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray[n22] = DenseDComplexMatrix3D.this.elements[n6];
                                    n6 += DenseDComplexMatrix3D.this.columnStride;
                                    n22 += n3;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n5 + i * this.sliceStride + j * this.rowStride;
                    int n11 = n4 + i * n + j * n2;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[n11] = this.elements[n10];
                        n10 += this.columnStride;
                        n11 += n3;
                    }
                }
            }
        }
        return denseDoubleMatrix3D;
    }

    public void ifft2Slices(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        for (int i = 0; i < this.slices; ++i) {
            ((DenseDComplexMatrix2D)this.viewSlice(i)).ifft2(bl);
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.complexInverse(this.elements, bl);
        } else {
            DComplexMatrix3D dComplexMatrix3D = this.copy();
            this.fft3.complexInverse((double[])dComplexMatrix3D.elements(), bl);
            this.assign((double[])dComplexMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    @Override
    public DComplexMatrix3D like(int n, int n2, int n3) {
        return new DenseDComplexMatrix3D(n, n2, n3);
    }

    @Override
    public void setQuick(int n, int n2, int n3, double d, double d2) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        this.elements[n4] = d;
        this.elements[n4 + 1] = d2;
    }

    @Override
    public void setQuick(int n, int n2, int n3, double[] dArray) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        this.elements[n4] = dArray[0];
        this.elements[n4 + 1] = dArray[1];
    }

    @Override
    public double[][][] toArray() {
        final int n = (int)this.index(0, 0, 0);
        final double[][][] dArray = new double[this.slices][this.rows][2 * this.columns];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[][] dArray3 = dArray[i];
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                double[] dArray2 = dArray3[j];
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray2[2 * k] = DenseDComplexMatrix3D.this.elements[n2];
                                    dArray2[2 * k + 1] = DenseDComplexMatrix3D.this.elements[n2 + 1];
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                double[][] dArray2 = dArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    double[] dArray3 = dArray2[j];
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray3[2 * k] = this.elements[n6];
                        dArray3[2 * k + 1] = this.elements[n6 + 1];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return dArray;
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D(this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            DComplexMatrix2D dComplexMatrix2D = this.viewSlice(i);
            denseDComplexMatrix1D.viewPart(i * n, n).assign(dComplexMatrix2D.vectorize());
        }
        return denseDComplexMatrix1D;
    }

    @Override
    public double[] zSum() {
        double[] dArray = new double[2];
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            int n4 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                n3 = i * n4;
                final int n5 = i == n2 - 1 ? this.slices : n3 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = new double[2];
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < DenseDComplexMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDComplexMatrix3D.this.sliceStride + j * DenseDComplexMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDComplexMatrix3D.this.columns; ++k) {
                                    dArray[0] = dArray[0] + DenseDComplexMatrix3D.this.elements[n2];
                                    dArray[1] = dArray[1] + DenseDComplexMatrix3D.this.elements[n2 + 1];
                                    n2 += DenseDComplexMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return dArray;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    double[] dArray2 = (double[])futureArray[n3].get();
                    dArray[0] = dArray[0] + dArray2[0];
                    dArray[1] = dArray[1] + dArray2[1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[0] = dArray[0] + this.elements[n6];
                        dArray[1] = dArray[1] + this.elements[n6 + 1];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return dArray;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D instanceof SelectedDenseDComplexMatrix3D) {
            SelectedDenseDComplexMatrix3D selectedDenseDComplexMatrix3D = (SelectedDenseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == selectedDenseDComplexMatrix3D.elements;
        }
        if (dComplexMatrix3D instanceof DenseDComplexMatrix3D) {
            DenseDComplexMatrix3D denseDComplexMatrix3D = (DenseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == denseDComplexMatrix3D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    @Override
    protected DComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseDComplexMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    @Override
    protected DComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseDComplexMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

