/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseDComplexMatrix3D
extends DComplexMatrix3D {
    protected ConcurrentHashMap<Integer, double[]> elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseDComplexMatrix3D(ConcurrentHashMap<Integer, double[]> concurrentHashMap, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = concurrentHashMap;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    @Override
    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    @Override
    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    @Override
    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    @Override
    public double[] getQuick(int n, int n2, int n3) {
        return this.elements.get(this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride]);
    }

    @Override
    public ConcurrentHashMap<Integer, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D instanceof SelectedSparseDComplexMatrix3D) {
            SelectedSparseDComplexMatrix3D selectedSparseDComplexMatrix3D = (SelectedSparseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == selectedSparseDComplexMatrix3D.elements;
        }
        if (dComplexMatrix3D instanceof SparseDComplexMatrix3D) {
            SparseDComplexMatrix3D sparseDComplexMatrix3D = (SparseDComplexMatrix3D)dComplexMatrix3D;
            return this.elements == sparseDComplexMatrix3D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    @Override
    public DComplexMatrix3D like(int n, int n2, int n3) {
        return new SparseDComplexMatrix3D(n, n2, n3);
    }

    @Override
    public DComplexMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported yet");
    }

    @Override
    protected DComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int n, int n2, int n3, double[] dArray) {
        int n4 = this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(n4);
        } else {
            this.elements.put(n4, dArray);
        }
    }

    @Override
    public void setQuick(int n, int n2, int n3, double d, double d2) {
        int n4 = this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(n4);
        } else {
            this.elements.put(n4, new double[]{d, d2});
        }
    }

    @Override
    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    @Override
    public DComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedSparseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    @Override
    public DComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    @Override
    protected DComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseDComplexMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }

    @Override
    public DComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseDComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    @Override
    public DoubleMatrix3D getImaginaryPart() {
        SparseDoubleMatrix3D sparseDoubleMatrix3D = new SparseDoubleMatrix3D(this.slices, this.rows, this.columns);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double[] dArray = this.getQuick(i, j, k);
                    ((DoubleMatrix3D)sparseDoubleMatrix3D).setQuick(i, j, k, dArray[1]);
                }
            }
        }
        return sparseDoubleMatrix3D;
    }

    @Override
    public DoubleMatrix3D getRealPart() {
        SparseDoubleMatrix3D sparseDoubleMatrix3D = new SparseDoubleMatrix3D(this.slices, this.rows, this.columns);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double[] dArray = this.getQuick(i, j, k);
                    ((DoubleMatrix3D)sparseDoubleMatrix3D).setQuick(i, j, k, dArray[0]);
                }
            }
        }
        return sparseDoubleMatrix3D;
    }
}

