/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexPlusMult;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 4055279694434233679L;
    protected ConcurrentHashMap<Integer, double[]> elements;
    protected int dummy;

    public SparseDComplexMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public SparseDComplexMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new ConcurrentHashMap(n * (n2 / 1000));
    }

    protected SparseDComplexMatrix2D(int n, int n2, ConcurrentHashMap<Integer, double[]> concurrentHashMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix2D assign(double[] dArray) {
        if (this.isNoView && dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        if (!(dComplexMatrix2D instanceof SparseDComplexMatrix2D)) {
            return super.assign(dComplexMatrix2D);
        }
        SparseDComplexMatrix2D sparseDComplexMatrix2D = (SparseDComplexMatrix2D)dComplexMatrix2D;
        if (sparseDComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseDComplexMatrix2D);
        if (this.isNoView && sparseDComplexMatrix2D.isNoView) {
            this.elements.clear();
            this.elements.putAll(sparseDComplexMatrix2D.elements);
            return this;
        }
        return super.assign(dComplexMatrix2D);
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        if (!this.isNoView) {
            return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
        }
        this.checkShape(dComplexMatrix2D);
        if (dComplexDComplexDComplexFunction instanceof DComplexPlusMult) {
            final double[] dArray = ((DComplexPlusMult)dComplexDComplexDComplexFunction).multiplicator;
            if (dArray[0] == 0.0 && dArray[1] == 1.0) {
                return this;
            }
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray2) {
                    SparseDComplexMatrix2D.this.setQuick(n, n2, DComplex.plus(SparseDComplexMatrix2D.this.getQuick(n, n2), DComplex.mult(dArray, dArray2)));
                    return dArray2;
                }
            });
            return this;
        }
        return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public double[] getQuick(int n, int n2) {
        double[] dArray = this.elements.get(this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride);
        if (dArray != null) {
            return new double[]{dArray[0], dArray[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Integer, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D instanceof SelectedSparseDComplexMatrix2D) {
            SelectedSparseDComplexMatrix2D selectedSparseDComplexMatrix2D = (SelectedSparseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == selectedSparseDComplexMatrix2D.elements;
        }
        if (dComplexMatrix2D instanceof SparseDComplexMatrix2D) {
            SparseDComplexMatrix2D sparseDComplexMatrix2D = (SparseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == sparseDComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    public DComplexMatrix2D like(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix1D like1D(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    @Override
    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        return new SparseDComplexMatrix1D(n, this.elements, n2, n3);
    }

    @Override
    public void setQuick(int n, int n2, double[] dArray) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(n3);
        } else {
            this.elements.put(n3, dArray);
        }
    }

    @Override
    public DComplexMatrix1D vectorize() {
        SparseDComplexMatrix1D sparseDComplexMatrix1D = new SparseDComplexMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                double[] dArray = this.getQuick(j, i);
                if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                sparseDComplexMatrix1D.setQuick(n++, dArray);
            }
        }
        return sparseDComplexMatrix1D;
    }

    @Override
    public void setQuick(int n, int n2, double d, double d2) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(n3);
        } else {
            this.elements.put(n3, new double[]{d, d2});
        }
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseDComplexMatrix2D(this.elements, nArray, nArray2, 0);
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.getQuick(i, j);
                ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(i, j, dArray[1]);
            }
        }
        return sparseDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.getQuick(i, j);
                ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(i, j, dArray[0]);
            }
        }
        return sparseDoubleMatrix2D;
    }
}

