/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.jet.math.tdouble.DoubleFunctions;
import java.io.Serializable;

public class DoubleQRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D QR;
    private int m;
    private int n;
    private DoubleMatrix1D Rdiag;

    public DoubleQRDecomposition(DoubleMatrix2D doubleMatrix2D) {
        int n;
        DoubleProperty.DEFAULT.checkRectangular(doubleMatrix2D);
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        this.QR = doubleMatrix2D.copy();
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        this.Rdiag = doubleMatrix2D.like1D(this.n);
        DoubleDoubleFunction doubleDoubleFunction = DoubleAlgebra.hypotFunction();
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[this.n];
        DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[this.n];
        for (n = 0; n < this.n; ++n) {
            doubleMatrix1DArray[n] = this.QR.viewColumn(n);
            doubleMatrix1DArray2[n] = this.QR.viewColumn(n).viewPart(n, this.m - n);
        }
        for (n = 0; n < this.n; ++n) {
            int n2;
            double d = 0.0;
            for (n2 = n; n2 < this.m; ++n2) {
                d = DoubleAlgebra.hypot(d, this.QR.getQuick(n2, n));
            }
            if (d != 0.0) {
                if (this.QR.getQuick(n, n) < 0.0) {
                    d = -d;
                }
                doubleMatrix1DArray2[n].assign(DoubleFunctions.div(d));
                this.QR.setQuick(n, n, this.QR.getQuick(n, n) + 1.0);
                for (n2 = n + 1; n2 < this.n; ++n2) {
                    DoubleMatrix1D doubleMatrix1D = this.QR.viewColumn(n2).viewPart(n, this.m - n);
                    double d2 = doubleMatrix1DArray2[n].zDotProduct(doubleMatrix1D);
                    d2 = -d2 / this.QR.getQuick(n, n);
                    for (int i = n; i < this.m; ++i) {
                        this.QR.setQuick(i, n2, this.QR.getQuick(i, n2) + d2 * this.QR.getQuick(i, n));
                    }
                }
            }
            this.Rdiag.setQuick(n, -d);
        }
    }

    public DoubleMatrix2D getH() {
        return DoubleAlgebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public DoubleMatrix2D getQ() {
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        DoubleMatrix2D doubleMatrix2D = this.QR.like();
        for (int i = this.n - 1; i >= 0; --i) {
            DoubleMatrix1D doubleMatrix1D = this.QR.viewColumn(i).viewPart(i, this.m - i);
            doubleMatrix2D.setQuick(i, i, 1.0);
            for (int j = i; j < this.n; ++j) {
                if (this.QR.getQuick(i, i) == 0.0) continue;
                DoubleMatrix1D doubleMatrix1D2 = doubleMatrix2D.viewColumn(j).viewPart(i, this.m - i);
                double d = doubleMatrix1D.zDotProduct(doubleMatrix1D2);
                d = -d / this.QR.getQuick(i, i);
                doubleMatrix1D2.assign(doubleMatrix1D, DoubleFunctions.plusMultSecond(d));
            }
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D getR() {
        DoubleMatrix2D doubleMatrix2D = this.QR.like(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i < j) {
                    doubleMatrix2D.setQuick(i, j, this.QR.getQuick(i, j));
                    continue;
                }
                if (i == j) {
                    doubleMatrix2D.setQuick(i, j, this.Rdiag.getQuick(i));
                    continue;
                }
                doubleMatrix2D.setQuick(i, j, 0.0);
            }
        }
        return doubleMatrix2D;
    }

    public boolean hasFullRank() {
        for (int i = 0; i < this.n; ++i) {
            if (this.Rdiag.getQuick(i) != 0.0) continue;
            return false;
        }
        return true;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D doubleMatrix1D) {
        int n;
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        if (doubleMatrix1D.size() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.copy();
        for (n = 0; n < this.n; ++n) {
            int n2;
            double d = 0.0;
            for (n2 = n; n2 < this.m; ++n2) {
                d += this.QR.getQuick(n2, n) * doubleMatrix1D2.getQuick(n2);
            }
            d = -d / this.QR.getQuick(n, n);
            for (n2 = n; n2 < this.m; ++n2) {
                doubleMatrix1D2.setQuick(n2, doubleMatrix1D2.getQuick(n2) + d * this.QR.getQuick(n2, n));
            }
        }
        for (n = this.n - 1; n >= 0; --n) {
            doubleMatrix1D2.setQuick(n, doubleMatrix1D2.getQuick(n) / this.Rdiag.getQuick(n));
            for (int i = 0; i < n; ++i) {
                doubleMatrix1D2.setQuick(i, doubleMatrix1D2.getQuick(i) - doubleMatrix1D2.getQuick(n) * this.QR.getQuick(i, n));
            }
        }
        return doubleMatrix1D2.viewPart(0, this.n).copy();
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        DoubleFunctions doubleFunctions = DoubleFunctions.functions;
        if (doubleMatrix2D.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n4;
                double d = 0.0;
                for (n4 = n2; n4 < this.m; ++n4) {
                    d += this.QR.getQuick(n4, n2) * doubleMatrix2D2.getQuick(n4, n);
                }
                d = -d / this.QR.getQuick(n2, n2);
                for (n4 = n2; n4 < this.m; ++n4) {
                    doubleMatrix2D2.setQuick(n4, n, doubleMatrix2D2.getQuick(n4, n) + d * this.QR.getQuick(n4, n2));
                }
            }
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            for (n = 0; n < n3; ++n) {
                doubleMatrix2D2.setQuick(n2, n, doubleMatrix2D2.getQuick(n2, n) / this.Rdiag.getQuick(n2));
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    doubleMatrix2D2.setQuick(n, i, doubleMatrix2D2.getQuick(n, i) - doubleMatrix2D2.getQuick(n2, i) * this.QR.getQuick(n, n2));
                }
            }
        }
        return doubleMatrix2D2.viewPart(0, 0, this.n, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("hasFullRank = ");
        try {
            stringBuffer.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nH = ");
        try {
            stringBuffer.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nQ = ");
        try {
            stringBuffer.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nR = ");
        try {
            stringBuffer.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\npseudo inverse(A) = ");
        try {
            stringBuffer.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

